package cn.com.duiba.projectx.sdk;

/**
 * 业务错误信息对象
 * 建议在开发活动时，每个活动单独定义枚举实现该接口，参考cn.com.duiba.projectx.sdk.demo.BizErrorDemo
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: BizError.java , v 0.1 2020-01-19 3:04 下午 ZhouFeng Exp $
 */
public interface BizError {

    default BizError of(int errorCode, String errorMessage) {
        return new BizError() {
            @Override
            public int errorCode() {
                return errorCode;
            }

            @Override
            public String errorMessage() {
                return errorMessage;
            }
        };
    }

    int errorCode();

    String errorMessage();
}
