package cn.com.duiba.projectx.sdk.component.exchange.vo;

import cn.com.duiba.projectx.sdk.component.exchange.dto.ExchangeConditionDto;

import java.util.List;

/**
 * @program: projectx
 * @description: 兑换限制信息Vo
 * @author: Simba
 * @create: 2021-02-25 14:19
 **/
public class ExchangeLimitInfoResult {

    /**
     * 限制类型
     */
    private int limitType;
    /**
     * 兑换限制条件
     */
    private List<ExchangeConditionDto> conditions;
    /**
     * 兑换限制次数
     */
    private Integer exchangeLimitCount;
    /**
     * 已兑换次数
     *
     * @desc ⚠️在兑换限制次数配置后该值有效，反之该值不做记录
     */
    private Long alreadyExchangeCount;

    private String extra;

    public int getLimitType() {
        return limitType;
    }

    public void setLimitType(int limitType) {
        this.limitType = limitType;
    }

    public List<ExchangeConditionDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ExchangeConditionDto> conditions) {
        this.conditions = conditions;
    }

    public Integer getExchangeLimitCount() {
        return exchangeLimitCount;
    }

    public void setExchangeLimitCount(Integer exchangeLimitCount) {
        this.exchangeLimitCount = exchangeLimitCount;
    }

    public Long getAlreadyExchangeCount() {
        return alreadyExchangeCount;
    }

    public void setAlreadyExchangeCount(Long alreadyExchangeCount) {
        this.alreadyExchangeCount = alreadyExchangeCount;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

