package cn.com.duiba.projectx.sdk.playway;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.dto.ActionRecordDto;
import cn.com.duiba.projectx.sdk.playway.join.JoinRecord;

import java.util.Date;
import java.util.List;

/**
 * 参与玩法API
 * 1.用户请求参与玩法的接口时，自定义代码区域可使用此API
 *
 * @author houwen
 */
public interface JoinUserRequestApi extends UserRequestApi {

    /**
     * 查询我的今日参与次数
     *
     * @return 用户当前活动今日的参与次数
     * @desc ⚠️ 该处参与不单指dojoin
     */
    public Long queryMyTodayCount();

    /**
     * 查询我连续参与的天数
     * 最多不超过100天
     *
     * @return 连续参与天数
     */
    public Integer queryMyContinueDays();

    /**
     * 查询我的永久参与次数
     *
     * @return 用户当前活动的所有参与次数
     */
    public Long queryMyAllCount();

    /**
     * 查询我最近的参与记录
     *
     * @param limit
     * @return
     */
    List<JoinRecord> queryMyRecentRecord(int limit);

    /**
     * 查询我的参与记录
     *
     * @param start
     * @param end
     * @return
     */
    public List<ActionRecordDto> queryMyRecords(Date start, Date end);

    /**
     * 记录一次参与
     *
     * @return 参与ID
     */
    public Long doJoin();

    /**
     * 记录一次参与
     *
     * @param extra 扩展信息
     * @return
     */
    public Long doJoin(String extra);

}
