package cn.com.duiba.projectx.sdk.component.task;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskQueryResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskResult;

/**
 * 分享组件玩法
 */
public abstract class TaskComponent {

    /**
     * 查询任务列表
     *  调用 api.queryTasks()
     * @param context
     * @param api
     * @return
     */
    public abstract TaskQueryResult queryTasks(UserRequestContext context, TaskApi api);

    /**
     * 完成任务
     *  请调用 api.doComplete()
     * @param context
     * @param api
     * @return
     */
    public abstract TaskResult doCompleted(UserRequestContext context, TaskApi api);

    /**
     * 发奖
     *  请调用 api.sendPrize()
     * @param context
     * @param api
     * @return
     */
    public abstract PrizeResult sendPrize(UserRequestContext context, TaskApi api);

}
