package cn.com.duiba.projectx.sdk.repeatable;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: EventContext.java , v 0.1 2020-01-21 10:09 上午 ZhouFeng Exp $
 */
public class EventContext {

    /**
     * 上下文参数
     */
    private Map<EventKeyWrapper, EventContextWrapper> content = new HashMap<>();

    public EventContext putValue(Class<? extends EventContextType> clazz, String key, EventContextWrapper value) {
        if (value == null || value.getValue() == null) {
            //如果值为空，则不放入上下文
            return this;
        }
        content.put(EventKeyWrapper.of(clazz, key), value);
        return this;
    }

    /**
     * @deprecated 使用getWrapperValue()
     */
    @Deprecated
    public Object getValue(Class<? extends EventContextType> clazz, String key) {
        return content.get(EventKeyWrapper.of(clazz, key));
    }

    public EventContextWrapper getWrapperValue(Class<? extends EventContextType> clazz, String key) {
        return content.get(EventKeyWrapper.of(clazz, key));
    }

    /**
     * 从上下文中取出值并清除
     *
     * @param key
     * @return
     * @deprecated 使用getWrapperValueAndClean
     */
    @Deprecated
    public Object getValueAndClean(Class<? extends EventContextType> clazz, String key) {
        Object value = content.get(EventKeyWrapper.of(clazz, key));
        clear(clazz, key);
        return value;
    }

    /**
     * 从上下文中取出值并清除
     *
     * @param key
     * @return
     */
    public EventContextWrapper getWrapperValueAndClean(Class<? extends EventContextType> clazz, String key) {
        EventContextWrapper value = content.get(EventKeyWrapper.of(clazz, key));
        clear(clazz, key);
        return value;
    }

    public String getStringValue(Class<? extends EventContextType> clazz, String key) {
        EventContextWrapper wrapper = content.get(EventKeyWrapper.of(clazz, key));
        if (wrapper == null) {
            return null;
        }
        return ((String) wrapper.getValue());
    }

    /**
     * 从上下文中取出值并清除
     *
     * @param key
     * @return
     */
    public String getStringValueAndClean(Class<? extends EventContextType> clazz, String key) {
        EventContextWrapper wrapper = content.get(EventKeyWrapper.of(clazz, key));
        if (wrapper == null) {
            return null;
        }
        String value = (String) wrapper.getValue();
        clear(clazz, key);
        return value;
    }

    private void clear(Class<? extends EventContextType> clazz, String key) {
        content.remove(EventKeyWrapper.of(clazz, key));
    }

    public Map<String, Object> export() {
        return content.entrySet().stream().filter(e -> e.getValue().isVisible())
                .collect(Collectors.toMap(e -> e.getKey().simpleKey(), e -> e.getValue().getValue()));
    }

}
