package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.CoordinateSystemEnum;
import cn.com.duiba.projectx.sdk.data.GeoInfoData;
import cn.com.duiba.projectx.sdk.data.PointParam;

/**
 * @program: projectx
 * @description:
 * @author: Simba
 * @create: 2021-06-24 20:20
 **/
public interface GeoApi {

    /**
     * 根据geoHash得到地理信息
     *
     * @param geoHash          地理编码
     * @param coordinateSystem 参考坐标系
     * @return 行政区信息
     */
    GeoInfoData findGeoInfoByGeoHash(String geoHash, CoordinateSystemEnum coordinateSystem);

    /**
     * 根据经纬坐标点查询地理信息
     *
     * @param point            经纬度坐标点
     * @param coordinateSystem 参考坐标系
     * @return 行政区信息
     */
    GeoInfoData findGeoInfoByPoint(PointParam point, CoordinateSystemEnum coordinateSystem);
}
