package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.redacc.AccRechargeRequest;
import cn.com.duiba.projectx.sdk.redacc.AccountCashDrawsOuterRequest;
import cn.com.duiba.projectx.sdk.redacc.AccountCashDrawsResponse;
import cn.com.duiba.projectx.sdk.redacc.AccountModifyResponse;
import cn.com.duiba.projectx.sdk.redacc.ActivityUniformityTypeEnum;
import cn.com.duiba.projectx.sdk.redacc.ConsumerAccInsertOuterParam;
import cn.com.duiba.projectx.sdk.redacc.ConsumerAccountsData;
import cn.com.duiba.projectx.sdk.redacc.ConsumerCashDrawsRecordData;
import cn.com.duiba.projectx.sdk.redacc.RedAccCustomData;
import cn.com.duiba.projectx.sdk.redacc.RedAccCustomRecordQueryParam;
import cn.com.duiba.projectx.sdk.redacc.RewardWithdrawTimeParam;

import java.util.List;

/**
 * 自定义红包接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedAccCustomApi.java , v 0.1 2019-10-31 14:34 ZhouFeng Exp $
 */
public interface RedAccCustomApi {

    /**
     * 查询自定义账户业务用户账户信息,没有则新建
     *
     * @return
     */
    ConsumerAccountsData getRedAccCustomAccount(ConsumerAccInsertOuterParam param);


    /**
     * 查询用户自定义账户提现机会剩余次数
     *
     * @param param
     * @return
     */
    Long getRewardWithdrawTimes(RewardWithdrawTimeParam param);


    /**
     * 自定义账户活动奖金入账
     *
     * @param request
     * @return
     */
    AccountModifyResponse redAccActBonusRecharge(AccRechargeRequest request);


    /**
     * 自定义账户用户账户提现
     *
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsOuterRequest}
     * @return
     */
    AccountCashDrawsResponse redAccCustomCashDraws(AccountCashDrawsOuterRequest request);

    /**
     * 自定义账户提现信息查询
     *
     * @param query
     * @return
     */
    List<ConsumerCashDrawsRecordData> selectRedAccCustomRecord(RedAccCustomRecordQueryParam query);

    /**
     * 自定义账户提现记录统计（按用户统计）
     *
     * @param query
     * @return
     */
    Long countRedAccCustomCashDraw4Consumer(RedAccCustomRecordQueryParam query);

    /**
     * 自定义账户提现金额统计
     *
     * @param query
     * @return
     */
    Long countRedAccCustomCashDraw(RedAccCustomRecordQueryParam query);

    /**
     * 通过唯一键查询
     *
     * @param relType
     * @param relId
     * @return
     */
    RedAccCustomData findByKey(Long appId, ActivityUniformityTypeEnum relType, Long relId);

}
