package cn.com.duiba.projectx.sdk.querytable;

import cn.com.duiba.projectx.sdk.utils.QueryTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Author: DSG
 * Date: 11:45 2021/7/28
 * Description: 查询条件构造器
 */
public class QueryWrapper<T> {
    private final Logger log = LoggerFactory.getLogger(QueryWrapper.class);
    private T entity;
    private final Map<SFunction<T, ?>, Object> eqMap = new HashMap<>();
    private final Map<SFunction<T, ?>, List<?>> inMap = new HashMap<>();
    private SFunction<T, ?> sortFunction = null;
    private QueryTable.SortType sortType = null;
    private Date gmtCreateStartTime = null;
    private Date gmtCreateEndTime = null;
    private Date gmtModifiedStartTime = null;
    private Date gmtModifiedEndTime = null;

    public QueryWrapper() {
    }

    public QueryWrapper(T entity) {
        this.entity = entity;
    }

    public T getEntity() {
        return entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public SFunction<T, ?> getSortFunction() {
        return sortFunction;
    }

    public QueryTable.SortType getSortType() {
        return sortType;
    }

    public Map<SFunction<T, ?>, Object> getEqMap() {
        return eqMap;
    }

    public Map<SFunction<T, ?>, List<?>> getInMap() {
        return inMap;
    }

    public QueryWrapper<T> eq(SFunction<T, ?> function, Object o) {
        eqMap.put(function, o);
        return this;
    }

    /**
     * in查询
     *
     * @param function
     * @param list
     * @return
     */
    public QueryWrapper<T> in(SFunction<T, ?> function, List<?> list) {
        inMap.put(function, list);
        return this;
    }

    public Date getGmtCreateStartTime() {
        return gmtCreateStartTime;
    }

    public QueryWrapper<T> gmtCreateTimeStartBy(Date gmtCreateStartTime) {
        this.gmtCreateStartTime = gmtCreateStartTime;
        return this;
    }

    public Date getGmtCreateEndTime() {
        return gmtCreateEndTime;
    }

    public QueryWrapper<T> gmtCreateTimeEndBy(Date gmtCreateEndTime) {
        this.gmtCreateEndTime = gmtCreateEndTime;
        return this;
    }

    public Date getGmtModifiedStartTime() {
        return gmtModifiedStartTime;
    }

    public QueryWrapper<T> gmtModifiedTimeStartBy(Date gmtModifiedStartTime) {
        this.gmtModifiedStartTime = gmtModifiedStartTime;
        return this;
    }

    public Date getGmtModifiedEndTime() {
        return gmtModifiedEndTime;
    }

    public QueryWrapper<T> gmtModifiedTimeEndBy(Date gmtModifiedEndTime) {
        this.gmtModifiedEndTime = gmtModifiedEndTime;
        return this;
    }

    /**
     * 排序不支持Data和Ext字段
     *
     * @param function
     * @param sortType
     * @return
     */
    public QueryWrapper<T> orderBy(SFunction<T, ?> function, QueryTable.SortType sortType) {
        this.sortFunction = function;
        this.sortType = sortType;
        return this;
    }
}
