package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.BizError;
import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: Response.java , v 0.1 2020-01-21 10:19 上午 ZhouFeng Exp $
 */
public class Response<I extends UserRequestApi> {

    /**
     * 是否需要立即中断
     */
    private boolean interrupt;

    /**
     * 中断后返回的错误信息
     */
    private BizError bizError;

    /**
     * 后继执行的ActionNode
     */
    private List<ActionNode<I>> insetNodes;

    
    private Map<String, Object> dataMap = new HashMap<>();

    public static <T extends UserRequestApi> Response<T> errorInterrupt(BizError bizError) {
        Response<T> response = new Response<>();
        response.setInterrupt(true);
        response.setBizError(bizError);
        return response;
    }


    public boolean isInterrupt() {
        return interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public BizError getBizError() {
        return bizError;
    }

    public void setBizError(BizError bizError) {
        this.bizError = bizError;
    }

    public List<ActionNode<I>> getInsetNodes() {
        return insetNodes;
    }

    public void setInsetNodes(List<ActionNode<I>> insetNodes) {
        this.insetNodes = insetNodes;
    }

    public Response<I> putAllData(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
        return this;
    }

    public Response<I> putData(String key, Object data) {
        dataMap.put(key, data);
        return this;
    }

    public Map<String, Object> getDataMap() {
        return dataMap;
    }
}
