package cn.com.duiba.projectx.sdk;


/**
 * 组件自定义运行时异常
 */
public class ComponentBizRuntimeException extends BizRuntimeException {

    private Integer code = 000000;

    /**
     * 是否需要warn级别日志输出
     */
    private boolean outWarnLog = true;

    public ComponentBizRuntimeException(String message) {
        super(message);
    }

    public ComponentBizRuntimeException(String message, boolean outWarnLog) {
        super(message);
        this.outWarnLog = outWarnLog;
    }

    public ComponentBizRuntimeException(BizError bizError) {
        super(bizError.errorMessage());
        this.code = bizError.errorCode();
    }

    public ComponentBizRuntimeException(BizError bizError, boolean outWarnLog) {
        super(bizError.errorMessage());
        this.code = bizError.errorCode();
        this.outWarnLog = outWarnLog;
    }

    public ComponentBizRuntimeException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    public ComponentBizRuntimeException(Integer code, String message, boolean outWarnLog) {
        super(message);
        this.code = code;
        this.outWarnLog = outWarnLog;
    }

    public ComponentBizRuntimeException(Integer code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public ComponentBizRuntimeException(Integer code, String message, Throwable cause, boolean outWarnLog) {
        super(message, cause);
        this.code = code;
        this.outWarnLog = outWarnLog;
    }

    public ComponentBizRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ComponentBizRuntimeException(String message, Throwable cause, boolean outWarnLog) {
        super(message, cause);
        this.outWarnLog = outWarnLog;
    }

    public ComponentBizRuntimeException(Throwable cause) {
        super(cause);
    }

    public ComponentBizRuntimeException(Throwable cause, boolean outWarnLog) {
        super(cause);
        this.outWarnLog = outWarnLog;
    }

    public Integer getCode() {
        return code;
    }

    public boolean isOutWarnLog() {
        return outWarnLog;
    }

}
