package cn.com.duiba.projectx.sdk.annotation;


import cn.com.duiba.projectx.sdk.riskmddata.MarkTypeEnum;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@EnableRiskControl
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface ExchangeRiskControl {

    /**
     * 风控场景
     */
    @AliasFor(annotation = EnableRiskControl.class,attribute = "value")
    MarkTypeEnum value() default MarkTypeEnum.EXCHANGE;


    /**
     * 默认不拦截
     * true 如果是黑名单用户直接拦截
     * false 不拦截黑名单用户
     * @return 是否拦截黑名单用户
     */
    @AliasFor(annotation = EnableRiskControl.class ,attribute = "filterBlack")
    boolean filterBlack() default false;
}
