package cn.com.duiba.projectx.sdk.component.checkin;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.base.OptionResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinResult;

import java.util.List;

/**
 * 签到组件玩法
 */
public abstract class CheckinComponent {

    /**
     * 查询签到奖品配置
     *  请调用 api.queryOptions()
     * @param context
     * @param api
     * @return
     */
    public abstract List<OptionResult> queryOptions(UserRequestContext context, CheckinApi api);

    /**
     * 签到
     *  请调用 api.doSign()
     * @param context
     * @param api
     * @return
     */
    public abstract CheckinResult doSign(UserRequestContext context, CheckinApi api);

    /**
     * 查询
     *  请调用 api.query()
     * @param context
     * @param api
     * @return
     */
    public abstract CheckinQueryResult query(UserRequestContext context, CheckinApi api);

}
