package cn.com.duiba.projectx.sdk.repeatable.utils;


import java.lang.reflect.Field;

/**
 * 反射工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ReflectUtils.java , v 0.1 2020-02-02 4:34 下午 ZhouFeng Exp $
 */
public class ReflectUtils {

    private ReflectUtils() {
        throw new UnsupportedOperationException();
    }

    /**
     * 字段赋值
     *
     * @param field 需要赋值的字段
     * @param object 被赋值的对象
     * @param value 要赋的值
     */
    public static void assign(Field field, Object object, String value) {
        field.setAccessible(true);
        Object o;
        if (field.getType() == int.class || field.getType() == Integer.class) {
            o = Integer.valueOf(value);
        } else if (field.getType() == double.class || field.getType() == Double.class) {
            o = Double.valueOf(value);
        } else if (field.getType() == long.class || field.getType() == Long.class) {
            o = Long.valueOf(value);
        } else if (field.getType() == String.class) {
            o = value;
        } else {
            throw new IllegalStateException(String.format("不支持的类型,%s.%s", object.getClass().getName(),
                    field.getName()));
        }
        try {
            field.set(object, o);
        } catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

}
