package cn.com.duiba.projectx.sdk.pay;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author lizhaojing
 * @Date 2021/1/12
 * 微信小程序支付入参
 */
public class WxPayLiteReq extends BasePayReq implements Serializable {
    private static final long serialVersionUID = -3534883556368757889L;

    /**
     * 业务方业务id，保证同一个项目下唯一
     */
    @NotNull
    private String bizId;
    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 终端设备信息
     * 可以不传
     */
    @Size(max = 32, message = "设备信息长度超过32")
    private String deviceInfo;

    /**
     * 授权码
     */
    @NotNull
    @Size(max = 128, message = "授权码超过128")
    private String authCode;

    /**
     * 支付成功回调地址：
     */
    @NotNull
    private String callbackUrl;

    /**
     * 订单标题
     * 会传给第三方支付
     * 不传默认为: 活动支付
     */
    private String body;

    private String extra;

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}
