package cn.com.duiba.projectx.sdk.pay.union.ums;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;
import cn.com.duiba.projectx.sdk.pay.union.UnionPayAcqAddnData;

/**
 * 〈浙江银联支付请求〉
 *
 * @author xcw
 * @create 2020/12/9
 * @since 1.0.0
 */
public class UnionChargeUmsRequest extends BasePayReq {

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;
    /**
     * 支付结果通知的地址，不传则走默认配置
     */
    private String resultNotifyUrl;

    /**
     * 支付金额   必传单位：分，最小1分
     */
    private Integer amount;

    /**
     * 商户代码  必传
     */
    private String mid;

    /**
     * 终端号 必传
     */
    private String tid;

    /**
     * 支付描述
     */
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }


    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getResultNotifyUrl() {
        return resultNotifyUrl;
    }

    public void setResultNotifyUrl(String resultNotifyUrl) {
        this.resultNotifyUrl = resultNotifyUrl;
    }

}