package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import com.google.common.collect.HashBasedTable;

import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: NodeFactory.java , v 0.1 2020-01-30 3:17 下午 ZhouFeng Exp $
 */
public class NodeFactory {

    private NodeFactory() {
        throw new UnsupportedOperationException();
    }

    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock(false);

    private static final HashBasedTable<Class<? extends Component<? extends UserRequestApi>>, String, ActionNode<?
            extends UserRequestApi>> CONTAINER = HashBasedTable.create();

    @SuppressWarnings("unchecked")
    public static void put(ActionNode<? extends UserRequestApi> node) {
        ReentrantReadWriteLock.WriteLock writeLock = LOCK.writeLock();
        try {
            //由于CONTAINER是静态变量，多个项目都会访问，需要上锁
            writeLock.lock();
            CONTAINER.put((Class<? extends Component<? extends UserRequestApi>>) node.getComponent().getClass(),
                    componentKey(node.getComponent().getId(), node.actionName()), node);
        } finally {
            writeLock.unlock();
        }
    }

    @SuppressWarnings("unchecked")
    public static <T extends ActionNode<? extends UserRequestApi>, V extends Component<?
            extends UserRequestApi>> T get(Class<V> clazz, String id, String actionName) {
        ReentrantReadWriteLock.ReadLock readLock = LOCK.readLock();
        try {
            readLock.lock();
            return (T) CONTAINER.get(clazz, componentKey(id, actionName));
        } finally {
            readLock.unlock();
        }
    }

    private static String componentKey(String id, String actionName) {
        return id + "_" + actionName;
    }

}
