package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.riskmddata.BlackListData;

/**
 * @author zhangruofan
 * @date 2020/04/10
 */
public interface BlackListServiceApi {
    /**
     * 新增活动黑名单返回id
     *
     * 新增失败抛BizRuntimeException异常
     *
     * @param blackListData black list data
     * @return record id
     * @deprecated {@link BlackListServiceApi#addActivityBlack(cn.com.duiba.projectx.sdk.UserRequestContext, java.lang.String, java.lang.String)}
     */
    @Deprecated
    Long insert(BlackListData blackListData);

    /**
     * 根据customerId查询
     * 查询失败抛BizRuntimeException异常
     * @param userId duiba user id
     * @return true 黑名单 false 非黑名单
     * @deprecated {@link BlackListServiceApi#isActivityBlack(java.lang.Long)}
     */
    @Deprecated
    Boolean findByUserId(Long userId);

    /**
     * 新增活动黑名单接口
     *
     * @param context    context
     * @param bannedDesc 封禁原因描述(项目自定义)
     * @return true添加成功 false添加失败
     */
    Boolean addActivityBlack(UserRequestContext context, String bannedDesc);

    /**
     * 当前用户是否是黑名单用户
     *
     * @param userId 兑吧cid
     * @return true是黑名单用户，false不是黑名单用户
     */
    Boolean isActivityBlack(Long userId);
}
