package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.data.UserSpRecordNew;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public interface StagePropertyApi extends Api {
    /**
     * 给用户发放道具
     * @param userId
     * @param spId
     * @param quantity
     * @return
     */
    Long giveStageProperty(String userId, String spId, int quantity);
    Long giveStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 消耗用户道具
     * @param userId
     * @param spId
     * @param quantity
     * @return
     */
    boolean consumeStageProperty(String userId, String spId, int quantity);
    boolean consumeStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 获取某个用户某个道具剩余数量
     * @param userId
     * @param spId
     * @return
     */
    long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取某个用户某些道具剩余数量，并组装map
     * @param userId
     * @param spIdList
     * @return
     */
    Map<String, Long> getSomebodySomeStageProperty(String userId, List<String> spIdList);

    /**
     * 获取某个用户所有道具的剩余数量，并组装map（如果存在非永久有效道具，慎用）
     * @param userId
     * @return
     */
    Map<String, Long> getSomebodyAllStageProperty(String userId);

    /**
     * 批量获取某些用户某个道具的剩余数量，并组装map
     * @param userIdList
     * @param spId
     * @return
     */
    Map<String, Long> getSpByUserIds(List<String> userIdList, String spId);

    /**
     * sum sp record
     * 获取扣减的或者增加的总数
     * 只能永久道具使用。
     *
     * @param userId    user id
     * @param spId      sp id
     * @param type      + -
     * @return sum
     */
    long sumSpRecord(String userId, String spId, String type);

    /**
     * 分页页查询用户道具记录
     * @param userId
     * @param spId
     * @param pageNum 从0开始
     * @param pageSize 不能大于200
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, long pageNum, long pageSize);

    /**
     * 分页页查询用户道具记录
     * @param userId
     * @param spId
     * @param type + -
     * @param pageNum 从0开始
     * @param pageSize 不能大于200
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, String type, long pageNum, long pageSize);

    /**
     * 根据时间范围分页查询用户道具记录
     * @param userId
     * @param spId
     * @param pageNum 从0开始
     * @param pageSize 不能大于200
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, long pageNum, long pageSize, LocalDateTime startTime, LocalDateTime endTime);

    /**
     * 根据时间范围分页查询用户道具记录
     * @param userId
     * @param spId
     * @param type + -
     * @param pageNum 从0开始
     * @param pageSize 不能大于200
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, String type, long pageNum, long pageSize, LocalDateTime startTime, LocalDateTime endTime);
}
