package cn.com.duiba.projectx.sdk.pay.icbcelife.app;

import java.util.Map;

/**
 * 工行-e生活-app支付
 * <link>https://open.icbc.com.cn/icbc/apip/api_detail.html?apiId=10000000000000022500&baseUrl=%2Fb2c%2Forderqry&resUrl=%2Fsearch&version=V1&apiName=%E6%94%AF%E4%BB%98%E7%BB%93%E6%9E%9C%E6%9F%A5%E8%AF%A2%E6%8E%A5%E5%8F%A3&serviceId=P0024&resourceId=10000000000000003040</>
 *
 * @author songp
 * @date 2024/5/12 12:26 下午
 */
public interface IcbcELifeAppPayApi {


    /**
     * 发起支付
     *
     * @param request 支付请求
     * @return 响应
     */
    IcbcELifePayResponse createIcbcELifePayCharge(IcbcELifePayReq request);

    /**
     * 支付结果通知解析
     *
     * @param paramMap 支付结果
     * @return 解析结果
     */
    IcbcELifePayNotifyResp orderNotify(Map<String, String> paramMap);

    /**
     * 发起退款
     *
     * @param request 发起退款
     * @return 退款结果
     */
    IcbcELifeRefundResp createRefund(IcbcELifeRefundReq request);

    /**
     * 支付结果查询
     *
     * @param request 请求参数
     * @return 查询结果
     */
    IcbcELifePayQueryResp payQuery(IcbcELifePayQueryReq request);

    /**
     * 退款结果查询
     *
     * @param request 请求参数
     * @return 查询结果
     */
    IcbcELifeRefundQueryResp refundQuery(IcbcELifeRefundQueryReq request);

}
