package cn.com.duiba.projectx.sdk.pay.icbcelife.app;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 工行-e生活-app支付-发起支付请求入参
 *
 * @author songp
 * @date 2024/2/20 5:41 下午
 */
public class IcbcELifePayReq extends BasePayReq {

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 商户代码
     * 唯一确定一个商户的代码，由商户在工行开户时，由工行告知商户。
     */
    private String merID;

    /**
     * 商户账号
     * 商户入账账号，只能交易时指定。
     * （商户付给银行手续费的账户，可以在开户的时候指定，也可以用交易指定方式；
     * 用交易指定方式则使用此商户账号）
     */
    private String merAcct;

    /**
     * 商品编号，选输
     */
    private String goodsID;

    /**
     * 商品名称，选输
     */
    private String goodsName;

    /**
     * 商品数量，选输
     */
    private Integer goodsNum;

    /**
     * 商城提示，选输
     */
    private String merHint;

    /**
     * 通知商户URL
     */
    @NotNull(message = "通知商户URL不能为空")
    private String notifyUrl;

    /**
     * 启动类型
     * 必输，
     * 取值：
     * 1：工行iPhone客户端版
     * 2：工行Android客户端版
     * 21：工行移动生活版（iPhone）
     * 22：工行移动生活版（Android）
     * 0：HTML版（只支持iPhone、Android的webkit核心浏览器）
     */
    private String clientType;

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;

    public String getMerID() {
        return merID;
    }

    public void setMerID(String merID) {
        this.merID = merID;
    }

    public String getMerAcct() {
        return merAcct;
    }

    public void setMerAcct(String merAcct) {
        this.merAcct = merAcct;
    }

    public String getGoodsID() {
        return goodsID;
    }

    public void setGoodsID(String goodsID) {
        this.goodsID = goodsID;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getGoodsNum() {
        return goodsNum;
    }

    public void setGoodsNum(Integer goodsNum) {
        this.goodsNum = goodsNum;
    }

    public String getMerHint() {
        return merHint;
    }

    public void setMerHint(String merHint) {
        this.merHint = merHint;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }
}
