package cn.com.duiba.projectx.sdk.pay.icbcelife.app;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 工行-e生活-app支付-发起退款请求入参
 *
 * @author songp
 * @date 2024/2/20 5:43 下午
 */
public class IcbcELifeRefundReq implements Serializable {

    private static final long serialVersionUID = 853582043406939930L;

    /**
     * 星速台下单支付订单号
     */
    @NotNull(message = "星速台订单号不能为空")
    private Long payRecordId;

    /**
     * 退款金额(单位分)
     */
    @NotNull(message = "退款金额不能为空")
    private Integer amount;

    /**
     * 退款原因
     */
    @NotNull(message = "退款原因不能为空")
    private String rejectReason;

    public Long getPayRecordId() {
        return payRecordId;
    }

    public void setPayRecordId(Long payRecordId) {
        this.payRecordId = payRecordId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }
}
