package cn.com.duiba.projectx.sdk.utils;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Http请求工具类
 * 1.get请求
 * 2.post请求
 */
public class HttpClient {

    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);

    private static RequestConfig config = RequestConfig.custom()
            .setConnectionRequestTimeout(5000)
            .setConnectTimeout(5000)
            .setSocketTimeout(5000)
            .build();

    /**
     * 发送HTTP GET 请求
     *
     * @param url 地址，参数拼接在url上
     * @return
     * @throws Exception
     */
    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet httpget = new HttpGet(url);
            httpget.setConfig(config);
            CloseableHttpResponse response = httpclient.execute(httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            LOG.error("httpclient.doGet:{}" + e.getMessage(), url);
            throw e;
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }

    /**
     * 发送HTTP POST 请求
     *
     * @param url    地址
     * @param params 参数
     * @return
     * @throws Exception
     */
    public static String doPost(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(config);
            List<NameValuePair> list = new ArrayList<>();
            if(params != null){
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(list);
            httppost.setEntity(formEntity);
            CloseableHttpResponse response = httpclient.execute(httppost);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            LOG.error("httpclient.doPost:{}" + e.getMessage(), params);
            throw e;
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }

    public static String doPost(String url, UrlEncodedFormEntity encodedFormEntity) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(config);
            httppost.setEntity(encodedFormEntity);
            CloseableHttpResponse response = httpclient.execute(httppost);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            LOG.error("httpclient.doPost:{}" + e.getMessage(), encodedFormEntity);
            throw e;
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }

    public static String doPost(String url, HttpEntity httpEntity) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(config);
            httppost.setEntity(httpEntity);
            CloseableHttpResponse response = httpclient.execute(httppost);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            LOG.error("httpclient.doPost:{}" + e.getMessage(), httpEntity);
            throw e;
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }



    public static String doGet(String url, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();

        HttpGet httpget = new HttpGet(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpget.setHeader(entry.getKey(),entry.getValue());
        }
        CloseableHttpResponse response = httpclient.execute(httpget);
        if (response.getStatusLine().getStatusCode() == 200) {
            return EntityUtils.toString(response.getEntity(), "UTF-8");
        }
        // fixme 异常日志处理
        throw new RuntimeException("请求失败："+response.getStatusLine().getStatusCode());
    }


    public static CloseableHttpResponse doPostResponse(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();

        HttpPost httppost = new HttpPost(url);

        List<NameValuePair> list = new ArrayList<>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(list);
        httppost.setEntity(formEntity);
        // fixme 异常日志处理
        return httpclient.execute(httppost);
    }
}
