package cn.com.duiba.projectx.sdk.component.newguide;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.newguide.dto.QueryNewGuideDto;
import cn.com.duiba.projectx.sdk.component.newguide.dto.StepNewGuideDto;

/**
 * @program: projectx
 * @description: 新手引导组件api
 * @author: Simba
 * @create: 2021-03-25 10:25
 **/
public interface NewGuideApi extends UserRequestApi {

    /**
     * 查询当前用户新手引导完成情况
     */
    QueryNewGuideDto queryNewGuide(String playwayId);

    /**
     * 递进新手引导完成的步数
     *
     * @param skip 是否跳过新手引导
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    StepNewGuideDto stepNewGuide(String playwayId, Boolean skip);

    /**
     * 重置新手引导步数
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     * 接口内不作业务限制，停留在任何一步重置后都会置为0
     */
    void resetSteps(String playwayId);
}

