package cn.com.duiba.projectx.sdk.repeatable.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 开发配置注解
 * 在MVP或组件中添加此注解，生成活动代码时可以自动在config.properties中生成配置
 * 在运行时，可以自动注入对应的配置，且会将运营配置优先注入
 *
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: DevConfig.java , v 0.1 2020-01-22 9:52 上午 ElinZhou Exp $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface DevConfig {

    String key();

    /**
     * 默认值，仅在自动生成配置时使用
     *
     * @return
     */
    String defaultValue() default "";

    String description();

    /**
     * 最小值
     * 相等也视为合法
     *
     * @return
     */
    double minInclude() default Double.NEGATIVE_INFINITY;

    /**
     * 最大值
     * 相等视为不合法
     *
     * @return
     */
    double maxExclude() default Double.MAX_VALUE;

    /**
     * 是否默认运营可配
     *
     * @return
     */
    boolean operatorConfig() default false;

}
