package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.data.CreditsParamData;

public interface CreditsApi extends Api {
    /**
     * 直接给用户增加积分
     * 没有用户中奖记录
     * 如果发放失败则抛运行时异常
     * @param userId      用户id 不能为空
     * @param quantity    积分数量 不能为空
     * @param description 描述，需要定制时通过该参数，可以为空
     */
    void sendCreditsPrize(String userId, Long quantity, String description);
    void sendCreditsPrize(String userId, Long quantity, String description, String transfer);

    /**
     * 扣积分失败通知
     * @param ticketNum
     * @param transfer
     * @param errorMsg
     * @return
     */
    Boolean deductCreditsFailNotify(String ticketNum, String transfer, String errorMsg);

    /**
     * 扣减拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口扣减拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean subTrustCredits(CreditsParamData creditsParamData);

    /**
     * 增加拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口增加拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean addTrustCredits(CreditsParamData creditsParamData);

    /**
     * 查询拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口查询拖管积分
     * @param userId
     * @return
     */
    Long queryTrustCreditsByConsumerId(String userId);
}
