package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.ComponentApi;
import cn.com.duiba.projectx.sdk.component.sendprize.dto.SendPrizeResult;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.data.Option4Inner;
import cn.com.duiba.projectx.sdk.data.ProjectWhiteListData;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecord;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecordForCreateTimeData;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecordForUpdateData;
import cn.com.duiba.projectx.sdk.data.UserSpRecordNew;
import cn.com.duiba.projectx.sdk.playway.base.Prize;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;
import cn.com.duiba.projectx.sdk.playway.base.UserData;
import org.springframework.web.client.RestTemplate;

import java.security.KeyStore;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ProjectApi extends Api {

    /**
     * @param prizeId
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#getPrizeStock(String)
     */
    @Deprecated
    PrizeStock getPrizeStock(String prizeId);

    /**
     * 批量获取奖品库存信息
     * @param ids prize ids
     * @return prize stock list
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#listPrizeStock(List)
     */
    @Deprecated
    List<PrizeStock> listPrizeStock(List<String> ids);

    /**
     * @param prizeId
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#getPrize(String)
     */
    @Deprecated
    Prize getPrize(String prizeId);

    /**
     * @param prizeIds
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#getPrizeList(List)
     */
    @Deprecated
    List<Prize> getPrizeList(List<String> prizeIds);

    /**
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    void insertKvStringData(String key, String value, Date expireTime);

    /**
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    void putKvStringData(String key, String value);


    /**
     * 增加/减少数值
     *
     * @param key
     * @param offset 增量
     * @param expire 失效时间
     * @return 变更后的数值
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#increase(String, long, ExpireTime)}
     */
    @Deprecated
    long increase(String key, long offset, Date expire);


    /**
     * 获取kv中的数值
     *
     * @param key
     * @return 当值不存在时返回null，存在时返回实际数值
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#getLong(String)}
     */
    @Deprecated
    Long getKvLong(String key);

    /**
     * 添加/更新KV记录
     *
     * @param key
     * @param value
     * @param expireTime
     * @return
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    boolean putKvStringData(String key, String value, Date expireTime);

    /**
     * 获取kv记录
     *
     * @param key
     * @return
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#get(String)}
     */
    @Deprecated
    String getKvStringData(String key);

    /**
     * 给用户发放道具
     * @param userId userId
     *
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#giveStageProperty(String, String, int)
     * @see StagePropertyApi#giveStageProperty(String, String, int, String)
     */
    @Deprecated
    Long giveStageProperty(String userId, String spId, int quantity);
    @Deprecated
    Long giveStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 注意：慎用，quantity传long,避免sp_record sum报错
     *
     * 给用户发放道具
     * @param userId userId
     *
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#giveStageProperty(String, String, int)
     * @see StagePropertyApi#giveStageProperty(String, String, int, String)
     */
    @Deprecated
    Long giveStageProperty(String userId, String spId, long quantity);
    @Deprecated
    Long giveStageProperty(String userId, String spId, long quantity, String extra);


    /**
     * 获取一个http请求实例,不同project之间相互隔离
     *
     * @return
     * @see UserRequestApi#getHttpHelper()
     */
    @Deprecated
    HttpHelper getHttpHelper();


    /**
     * 获取RestTemplate
     *
     * 内网服务调用，域名直接用服务名，有默认负载均衡
     * @return
     * @see UserRequestApi#getRestTemplate()
     */
    @Deprecated
    RestTemplate getRestTemplate();

    /**
     * 获取异步http请求实例
     * @return
     * @see UserRequestApi#getHttpAsyncClient()
     */
    @Deprecated
    HttpAsyncClient getHttpAsyncClient();

    /**
     * 获取一个https请求实例
     *
     * @param name     实例的名称，不同实例间隔离
     * @param keyStore 证书
     * @return
     * @see UserRequestApi#getHttpHelper(String, KeyStore)
     */
    @Deprecated
    HttpHelper getHttpHelper(String name, KeyStore keyStore);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#consumeStageProperty(String, String, int)
     * @see StagePropertyApi#consumeStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, int quantity);
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#consumeStageProperty(String, String, int)
     * @see StagePropertyApi#consumeStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, long quantity);
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, long quantity, String extra);

    /**
     * 查询某人所有的道具的数量信息
     *
     * @param userId 需要查询的用户
     * @return key:道具id，value:拥有的道具数
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#getSomebodyAllStageProperty(String)
     */
    @Deprecated
    Map<String, Long> getSomebodyAllStageProperty(String userId);

    /**
     * 查询某些用户的某个道具数
     * @param userIds 用户id最多支持1000人，超过抛异常
     * @param spId sp id
     * @return map user id -> sp count
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#getSpByUserIds(List, String)
     */
    @Deprecated
    Map<String, Long> getSpByUserIds(List<String> userIds, String spId);
    /**
     * 查询某人的某个道具的数量
     *
     * @param userId 需要查询的用户
     * @param spId   道具id
     * @return
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#getSomebodyStageProperty(String, String)
     */
    @Deprecated
    Long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @return list
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#queryOptions(String)
     */
    @Deprecated
    List<Option> queryOptions(String strategyId);


    /**
     * 获取某个发奖策略下面的奖项列表(内部使用，会暴露中奖概率)
     *
     * @param strategyId 发奖策略id
     * @return list
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#queryOptions4Inner(String)
     */
    @Deprecated
    List<Option4Inner> queryOptions4Inner(String strategyId);

    /**
     * list user data
     * user id 的个数不能超过500个，超过会抛异常
     * @param key key
     * @param userIds user ids
     * @return user data list
     * @see UserRequestApi#getUserDataNewApi()
     * @see UserDataNewApi#multiGetUserData(List, String)
     * @see UserDataNewApi#multiGetUserDataLong(List, String)
     * @see UserDataNewApi#multiGetUserDataObject(List, String, Class)
     */
    @Deprecated
    List<UserData> batchListUserData(String key, List<String> userIds);

    /**
     * 判断某个用户是否是开发者白名单用户
     *
     * @param partnerUserId
     * @param projectId
     * @return user data list
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#isWhiteListUser(String)
     */
    @Deprecated
    Boolean isWhiteListUser(String projectId ,String partnerUserId);

    /**
     * 获取某个用户在白名单的的一行记录的多列数据
     *
     * @param projectId 项目ID
     * @param partnerUserId 用户标识
     * @param groupId 分组ID   注：不传默认为：0
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#listWhiteByPartnerUserId(String)
     */
    @Deprecated
    String[] getWhiteListByUserId(String projectId ,String partnerUserId, String groupId);

    /**
     * 查询用户命中的白名单列表
     * @param partnerUserId 用户标识
     * @param groupIds 白名单group范围，可不填
     * @return 命中的白名单groupId列表(不为空，size可为0),最多获取100条
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#listWhiteByPartnerUserId(String)
     */
    @Deprecated
    List<String> getWhiteListUserByPIdAndGroupIds(String partnerUserId, Collection<String> groupIds);

    /**
     * 获取开发者白名单下某个 group 的白名单集合
     * @param groupId
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#getWhitePartnerUserIdListByGroupId(String)
     */
    @Deprecated
    List<String> getWhiteListByGroup(String groupId);

    /**
     * 获取当前用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#listSomebodyUserPrizeRecord(String, boolean)
     */
    @Deprecated
    List<UserPrizeRecord> listUserPrizeRecord(boolean ignoreAddCredits);

    /**
     * 获取当前用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @param ignoreSp 是否忽略道具   true: 忽略  false:不忽略
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#listSomebodyUserPrizeRecord(String, boolean, boolean)
     */
    @Deprecated
    List<UserPrizeRecord> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits, boolean ignoreSp);

    /**
     * 获取制定用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     * @param userId 用户ID
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#listSomebodyUserPrizeRecord(String, boolean)
     */
    @Deprecated
    List<UserPrizeRecord> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits);

    /**
     * 根据主键id查询中奖记录
     * @param id 主键ID
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#getPrizeRecordById(Long)
     */
    @Deprecated
    UserPrizeRecord getPrizeRecordById(Long id);

    /**
     * 判断某个用户在当前项目是否是开发者白名单用户
     * @param partnerUserId
     * @param groupId 分组类型id （不使用传null，默认查所有组）
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#isWhiteListUser(String, String)
     */
    @Deprecated
    Boolean isWhiteListUserByPIdAndGroupId(String partnerUserId ,String groupId);

    /**
     * 根据partnerUserId，groupId删除白名单
     * @param partnerUserIds
     * @param groupId 分组类型id （不使用传null，默认查所有组）
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#deleteByGroupIdAndPartnerUserIdList(String, List)
     */
    @Deprecated
    int deleteByPIdAndGroupId(String projectId,String groupId,List<String> partnerUserIds);

    /**
     * 新增白名单,主键或（projectId，groupId，partnerUserId）唯一索引冲突则更新
     * @param partnerUserId
     * @param partnerExtra 扩展字段
     * @param groupId 分组类型id （不传，默认 0）
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#insertOrUpdate(String, String, String)
     */
    @Deprecated
    int insertOrUpdate(String projectId,String groupId,String partnerUserId,String partnerExtra);

    /**
     * 批量新增白名单，一次最多2000条 主键或（projectId，groupId，partnerUserId）唯一索引冲突则更新
     * @param projectWhiteListDataList 只需传partnerUserId，和partnerExtra
     * @param groupId 分组类型id
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#insertOrUpdateList(String, List)
     */
    @Deprecated
    int insertOrUpdateList(String projectId,String groupId,List<ProjectWhiteListData> projectWhiteListDataList);


    /**
     * 根据pid获取白名单用户信息（根据groupId去重）
     * @param partnerUserId
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#listWhiteByPartnerUserId(String)
     */
    @Deprecated
    List<ProjectWhiteListData> listWhiteByPartnerUserId(String partnerUserId);


    /**
     * 根据groupId获取白名单用户信息
     * @param groupId
     * @param page
     * @param pageSize
     * @param startId 开始id，包括此id，可以为空
     * @return
     * @see UserRequestApi#getWhiteListApi()
     * @see WhiteListApi#pageListWhiteByGroupId(String, int, int, Long)
     */
    @Deprecated
    PageList<ProjectWhiteListData> listWhiteByGroupId(String groupId, int page, int pageSize,Long startId);

    /**
     * sum sp record
     * 获取扣减的或者增加的总数
     * 只能永久道具使用。
     *
     * @param userId    user id
     * @param spId      sp id
     * @param type      + -
     * @return sum
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#sumSpRecord(String, String, String)
     */
    @Deprecated
    Long sumSpRecord(String userId, String spId, String type);

    /**
     * 分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     * @param userId
     * @param spId
     * @param pageNum
     * @param pageSize
     * @return
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#pageQuerySpRecord(String, String, long, long)
     */
    @Deprecated
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, long pageNum, long pageSize);

    /**
     * 分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     * @param userId
     * @param spId
     * @param type + -
     * @param pageNum
     * @param pageSize
     * @return
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#pageQuerySpRecord(String, String, String, long, long)
     */
    @Deprecated
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, String type,long pageNum, long pageSize);

    /**
     * 根据时间范围分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     * @param userId
     * @param spId
     * @param pageNum
     * @param pageSize
     * @return
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#pageQuerySpRecord(String, String, long, long, LocalDateTime, LocalDateTime)
     */
    @Deprecated
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, long pageNum, long pageSize, LocalDateTime startTime, LocalDateTime endTime);

    /**
     * 根据时间范围分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     *
     * @param userId
     * @param spId
     * @param type + -
     * @param pageNum
     * @param pageSize
     * @return
     * @see UserRequestApi#getStagePropertyApi()
     * @see StagePropertyApi#pageQuerySpRecord(String, String, String, long, long, LocalDateTime, LocalDateTime)
     */
    @Deprecated
    PageList<UserSpRecordNew> pageQuerySpRecord(String userId, String spId, String type, long pageNum, long pageSize, LocalDateTime startTime, LocalDateTime endTime);

    /**
     * 组件API
     *
     * @return
     * @see UserRequestApi#getComponentApi()
     */
    @Deprecated
    ComponentApi getComponentApi();

    /**
     * 根据场景id查询对应的发奖规则
     *
     * @param sceneId
     * @return
     * @see UserRequestApi#queryRuIdsBySceneId(String)
     */
    @Deprecated
    List<String> queryRuIdsBySceneId(String sceneId);

    /**
     * 根据场景id发奖
     *
     * @param sceneId
     * @return
     * @see UserRequestApi#sendPrizeBySceneId(String)
     */
    @Deprecated
    SendPrizeResult sendPrizeBySceneId(String sceneId);

    /**
     * 新增用户中奖记录包括创建和更新时间
     *
     * @param record 新增记录
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#insertUserPrizeRecord(String, UserPrizeRecordForCreateTimeData)
     */
    @Deprecated
    void insertUserPrizeRecord(UserPrizeRecordForCreateTimeData record);

    /**
     * 修改用户中奖记录
     *
     * @param record 新增记录
     * @return
     * @see UserRequestApi#getPrizeApi()
     * @see PrizeApi#updateUserPrizeRecordById(String, UserPrizeRecordForUpdateData)
     */
    @Deprecated
    boolean updateUserPrizeRecordById(UserPrizeRecordForUpdateData record);

}
