package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.backend.ranking.ManualSendPrizeCallable;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.kv.KvOperations;
import cn.com.duiba.projectx.sdk.utils.Field;
import cn.com.duiba.projectx.sdk.utils.QueryTable;

import java.util.List;

/**
 * 后台手动开奖API
 * @author zhangruofan
 * @date 2019/10/24
 */
public interface BackendRankingApi {
    /**
     * 直接发奖
     * @param strategyId 直接出奖策略id
     * @param userId 用户id
     * @param prizeId 奖品Id
     * @return 发奖是否成功
     */
    boolean sendPrize(String strategyId, String userId, String prizeId);

    boolean sendPrize(String strategyId, String userId, String prizeId, String spPrizeExtra);

    /**
     * 执行开奖逻辑
     * @param type 排行榜type
     * @param topN 获取前几名开奖
     * @param callable 开奖回调
     */
    void manualSendPrize(String type, int topN,  ManualSendPrizeCallable callable);

    /**
     * get kv operations
     * @return kv operations
     */
    KvOperations kvOps();

    /**
     * 获取某个发奖策略下的所有奖项
     * @param strategyId 发奖策略id
     * @return 奖项列表
     */
    List<Option> queryOptions(String strategyId);

    /**
     * 直接发奖返回中奖结果
     * @param strategyId 发奖策略id
     * @param userId 用户id
     * @param prizeId 奖品id
     * @return result
     */
    SendPrizeResult directSendPrize(String strategyId, String userId, String prizeId);

    SendPrizeResult directSendPrize(String strategyId, String userId, String prizeId, String spPrizeExtra);

    /**
     * 获取一个QueryTable实例
     *
     * @param group 数据分组
     * @param clazz 映射类型
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);
}
