package cn.com.duiba.projectx.sdk.kww;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.kww.dto.BookCategoryDto;
import cn.com.duiba.projectx.sdk.kww.dto.BookChapterDto;
import cn.com.duiba.projectx.sdk.kww.dto.BookDto;
import cn.com.duiba.projectx.sdk.kww.dto.BookQueryParam;
import cn.com.duiba.projectx.sdk.utils.PageList;

import java.util.List;

public interface KwwBookApi extends Api {

    /**
     * 分页查询书籍列表
     * 不含作品简介
     *
     * @param bookQueryParam
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageList<BookDto> bookListPage(BookQueryParam bookQueryParam, Integer pageNo, Integer pageSize);

    /**
     * 根据书籍id查询书籍信息
     * 不返回简介信息
     * 最多返回200条
     *
     * @param bookId
     * @return
     */
    List<BookDto> queryByBookIds(List<Integer> bookId);

    /**
     * 根据书籍id查询书籍信息(包含书籍简介)
     *
     * @param bookId
     * @return
     */
    BookDto queryByBookId(Integer bookId);


    /**
     * 模糊搜索(包含50字以内书籍简介)
     *
     * @param key
     * @return
     */
    List<BookDto> searchBookByKey(String key);

    /**
     * 根据书籍id分页查询章节列表(不包含章节具体内容)
     *
     * @param bookId
     * @param sortType 1降序 2升序
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageList<BookChapterDto> bookChapterListPage(Integer bookId, Integer sortType, Integer pageNo, Integer pageSize);

    /**
     * 根据书籍id,章节序号,查询章节内容
     *
     * @param bookId
     * @param displayOrder
     * @return
     */
    BookChapterDto queryByBookIdAndChapterOrder(Integer bookId, Integer displayOrder);

    /**
     * 查询当前书籍最大章节
     *
     * @param bookId
     * @return
     */
    BookChapterDto queryMaxBookChapterId(Integer bookId);


    /**
     * 查询所有分类列表
     *
     * @return
     */
    List<BookCategoryDto> queryAllBookCategoryList();

    /**
     * 根据分类id查询分类
     *
     * @param categoryId
     * @return
     */
    BookCategoryDto queryByCategoryId(Integer categoryId);
}
