package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.data.ConsumerData;
import cn.com.duiba.projectx.sdk.data.ConsumerExtra;
import cn.com.duiba.projectx.sdk.data.IdentityCustomerRelationData;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;

public interface ConsumerApi extends Api {

    /**
     * 根据用户id获取ConsumerData
     * @param userId 如果不是空也不是数字，会抛异常
     * @return
     * @throws BizRuntimeException
     */
    ConsumerData getConsumerData(String userId) throws BizRuntimeException;

    /**
     * 根据用户id列表批量获取ConsumerData，并组装map
     * @param userIdList 单次最多2000个，如果存在不是空也不是数字的元素，会抛异常
     * @return
     * @throws BizRuntimeException
     */
    Map<String, ConsumerData> getConsumerDataMap(List<String> userIdList) throws BizRuntimeException;

    /**
     * 根据用户id判断用户是否是新用户
     * @param userId 如果不是空也不是数字，会抛异常
     * @return
     * @throws BizRuntimeException
     */
    boolean isNewUser(String userId) throws BizRuntimeException;

    /**
     * 从用户ConsumerData中获取用户剩余积分
     * @param userId
     * @return
     * @throws BizRuntimeException
     */
    long getUserLeftCredits(String userId) throws BizRuntimeException;

    /**
     * 根据用户id获取ConsumerExtra
     * @param userId 如果不是空也不是数字，会抛异常
     * @return
     */
    ConsumerExtra getConsumerExtra(String userId) throws BizRuntimeException;

    /**
     * 根据用户id列表批量获取ConsumerExtra，并组装map
     * @param userIdList 单次最多2000个，如果存在不是空也不是数字的元素，会抛异常
     * @return
     */
    Map<String, ConsumerExtra> getConsumerExtraMap(List<String> userIdList) throws BizRuntimeException;

    /**
     * 获取ConsumerExtra.json（针对一次需要获取多个字段的情况）
     * @param userId 如果不是空也不是数字，会抛异常
     * @return 如果json不为空，则反序列化，否则返回 new JSONObject()，不会返回null
     */
    JSONObject getConsumerExtraJson(String userId) throws BizRuntimeException;

    /**
     * 获取ConsumerExtra.json里面的某个字段
     * @param userId 如果不是空也不是数字，会抛异常
     * @param key
     * @return
     * @throws BizRuntimeException
     */
    String getConsumerExtraJsonValue(String userId, String key) throws BizRuntimeException;

    /**
     * @param consumerId
     * @return
     * @see #getConsumerData(String)
     */
    @Deprecated
    ConsumerData getConsumerData(Long consumerId);

    /**
     * 批量获取用户extra信息
     * @param ids consumer ids
     * @return list
     * @throws BizRuntimeException exception
     * @see #getConsumerExtraMap(List)
     */
    @Deprecated
    List<ConsumerExtra> listConsumerExtraByConsumerIds(List<Long> ids) throws BizRuntimeException;

    /**
     * 批量获取用户信息
     * @param ids consumer ids
     * @return list
     * @throws BizRuntimeException exception
     * @see #getConsumerDataMap(List)
     */
    @Deprecated
    List<ConsumerData> listConsumerByConsumerIds(List<Long> ids) throws BizRuntimeException;

    /**
     * 当前用户是否为新用户
     * true 新用户  false 老用户
     * @param consumerId consumerId
     * @return boolean
     * @throws BizRuntimeException exception
     * @see #isNewUser(String)
     */
    @Deprecated
    boolean isNewUser(Long consumerId) throws BizRuntimeException;

    /**
     * 通过开发者用户id获取用户信息
     * @param appId appId
     * @param partnerUserId 开发者用户id
     * @return consumer
     * @throws BizRuntimeException exception
     */
    ConsumerData findByAppAndPartnerUserId(Long appId, String partnerUserId);

    /**
     * 通过开发者用户id获取用户信息
     * @param appId appId
     * @param partnerUserIds 开发者用户id集合
     * @return consumer
     * @throws BizRuntimeException exception
     */
    List<ConsumerData> findByAppAndPartnerUserIds(Long appId, List<String> partnerUserIds);

    /**
     * 获取扩展字段信息
     * @param consumerId
     * @param key
     * @return
     * @deprecated consumer表查找
     */
    @Deprecated
    String findExtra(Long consumerId, String key) throws BizRuntimeException;

    /**
     * @description  通过key 查询consumerExtra表json里的扩展字段
     * @author liheping
     * @date 2020/12/3
     * @see #getConsumerExtraJsonValue(String, String)
     */
    @Deprecated
    String findConsumerExtra(Long consumerId, String key);

    /**
     * 定制接口
     * 查询用户关系绑定
     * @param uidBeats
     * @param appId
     * @param relType
     * @return
     */
    List<IdentityCustomerRelationData> listByRelContents(List<String> uidBeats, Long appId, String relType);
}
