package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.component.ComponentApi;
import cn.com.duiba.projectx.sdk.component.sendprize.dto.SendPrizeResult;
import cn.com.duiba.projectx.sdk.data.CreditsRecord;
import cn.com.duiba.projectx.sdk.data.SensitiveWordData;
import cn.com.duiba.projectx.sdk.playway.base.UserContext;
import cn.com.duiba.projectx.sdk.template.RedisLock;
import cn.com.duiba.projectx.sdk.utils.ConfigurationApi;
import cn.com.duiba.projectx.sdk.utils.CreditsApi;
import cn.com.duiba.projectx.sdk.utils.DuibaApi;
import cn.com.duiba.projectx.sdk.utils.HttpAsyncClient;
import cn.com.duiba.projectx.sdk.utils.PrizeApi;
import cn.com.duiba.projectx.sdk.utils.ProjectApi;
import cn.com.duiba.projectx.sdk.utils.RankingApi;
import cn.com.duiba.projectx.sdk.utils.StagePropertyApi;
import cn.com.duiba.projectx.sdk.utils.UserDataApi;
import cn.com.duiba.projectx.sdk.utils.UserLock;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * 用户请求作用域内可使用的API
 *
 * @author xuhengfei
 */
public interface UserRequestApi extends Api, CommonApi {

    /**
     * 回退当前用户针对某个玩法某个动作扣积分未使用的积分票据【需要则在首页接口触发，不需要则不触发】
     * @param playwayId 扣积分的玩法id（必传）
     * @param actionId 扣积分的动作id（必传）
     * @param startTime 开始时间，创建时间大于等于这个时间（可以传null，表示不限定创建时间下限）
     * @param endTime 结束时间，创建时间小于等于这个时间 （传null 或 传的值大于当前时间1分钟前，则会取当前时间1分钟前）
     * @param maxDealCount 最多处理几个（必传，最大传5，超过会取5，单次不要处理太多个，可能会导致接口超时，建议单次处理1个）
     * @param desc 回退积分描述（必传）
     * @param transfer transfer参数（不需要指定则传null，会取context里面的transfer值）
     */
    void returnCurrentUserUnusedTickets(String playwayId, String actionId, Date startTime, Date endTime, int maxDealCount, String desc, String transfer);

    /**
     * 获取当前用户对应玩法动作下对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param playwayId
     * @param actionId
     * @param quantity
     * @return
     */
    List<CreditsRecord> findUnusedTicketList(String playwayId, String actionId, Long quantity);

    /**
     * 获取当前用户对应玩法动作下,某段时间生成的对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param playwayId 玩法id(选填)
     * @param actionId  actionId(选填)
     * @param quantity  积分数量(选填)
     * @param startTime 开始时间(选填) （startTime<=gmt_create）
     * @param endTime   结束时间(选填)  (endTime>=gmt_create)
     * @return
     */
    List<CreditsRecord> findUnusedTicketList(String playwayId, String actionId, Long quantity, Date startTime, Date endTime);


    /**
     * 丢弃门票，将门票由未使用状态标记为不可用
     * 积分扣除成功且未被使用，才能设置为丢弃
     *
     * @param ticketNum     门票id(必填)
     * @param discardReason 不可用的原因(必填)
     * @return 是否修改成功
     */
    boolean discardTicket(String ticketNum, String discardReason);

    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 票据单号
     * @return creditsRecord
     */
    Optional<CreditsRecord> getCreditsTicket(String ticketNum);

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    boolean useCreditsTicket(String ticketNum);

    /**
     * 扣积分失败通知(特殊场景下使用)
     * 将扣积分成功的记录再发一遍失败结果通知给开发者
     *
     * @param ticketNum
     * @param transfer
     * @param errorMsg
     * @return
     * @see #getCreditsApi()
     * @see CreditsApi#deductCreditsFailNotify(String, String, String)
     */
    @Deprecated
    Boolean deductCreditsFailNotify(String ticketNum, String transfer, String errorMsg);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getIntVariable(String)
     */
    @Deprecated
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getStringVariable(String)
     */
    @Deprecated
    String getStringVariable(String key);

    /**
     * 获取运营配置变量 image类型
     *
     * @param key
     * @return
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getImageVariable(String)
     */
    @Deprecated
    String getImageVariable(String key);

    /**
     * 获取运营配置变量Date
     *
     * @param key 配置项Variable
     * @return 变量对应的Date值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getDateVariable(String)
     * @see ConfigurationApi#getLocalDateTimeVariable(String)
     */
    @Deprecated
    Date getDateVariable(String key);

    /**
     * 获取json配置项
     * <p>
     * 适用条件：
     * 1、配置项，类型为json；
     * 2、配置项，值为单个json对象（即解析为表单后仅有1行数据）；
     * <p>
     * 注意事项：
     * 1、当配置项真实值解析为表单后存在多行数据时，调用此方法会抛出业务异常！若设计如此则应使用{@link UserRequestApi#getJsonArrayVariable(String, Class)}；
     *
     * @param key    key
     * @param tClass tClass
     * @return {@link T}
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getJsonVariable(String, Class)
     */
    @Deprecated
    <T> T getJsonVariable(String key, Class<T> tClass);

    /**
     * 获取json数组配置项
     * <p>
     * 适用条件：
     * 1、配置项，类型为json；
     * 2、配置项，值为多个json对象（即jsonArray，解析为表单后存在多行数据）；
     * <p>
     * 注意事项：
     * 1、当配置项真实值解析为表单后仅存在"1"行数据时，建议使用{@link UserRequestApi#getJsonVariable(String, Class)}，该方法直接返回解析列表中的唯一数据对象！
     *
     * @param key    key
     * @param tClass tClass
     * @return {@link List}<{@link T}>
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getJsonArrayVariable(String, Class)
     */
    @Deprecated
    <T> List<T> getJsonArrayVariable(String key, Class<T> tClass);

    /**
     * 获得当前Action自动生成的记录ID
     * (预设接口内才能获取到，自定义接口中无法获取到)
     *
     * @return 记录ID
     */
    Long getCurrentRecordId();

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     * @see #sendPrizeByStrategyId(String, String)
     * @see #sendPrizeByStrategyIdFailedToThanks(String, String)
     */
    @Deprecated
    StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 使用发奖策略出奖
     * 可以指定一个用户进行策略发奖
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     * @see #sendPrizeByStrategyId(String, String)
     * @see #sendPrizeByStrategyIdFailedToThanks(String, String)
     * @see #sendPrizeByStrategyIdWithUndertakeFailedToThanks(String, String, String)
     */
    @Deprecated
    StrategyResult sendPrizeWithStrategy(String userId, String prizeStrategyId);

    /**
     * 给指定用户，使用指定发奖规则发奖（可能抛异常，有事务控制时，慎用）
     * @param userId
     * @param strategyId
     * @return
     */
    SendPrizeResult sendPrizeByStrategyId(String userId, String strategyId);

    SendPrizeResult assembleThanks(String strategyId);

    /**
     * 给指定用户，使用指定发奖规则发奖（不会抛异常，一定有结果，失败了或异常了【异常会打印error日志】，会返回谢谢参与，中了谢谢参与时该如何处理，由业务层自行判断处理）
     * @param userId
     * @param strategyId
     * @return
     */
    SendPrizeResult sendPrizeByStrategyIdFailedToThanks(String userId, String strategyId);

    /**
     * 给指定用户，使用指定发奖规则发奖（不会抛异常，一定有结果，中了谢谢参与或失败了或异常了【异常会打印error日志】，会走兜底奖池，兜底奖池失败了或异常了【异常会打印error日志】，会返回谢谢参与，中了谢谢参与时该如何处理，由业务层自行判断处理）
     * @param userId
     * @param strategyId
     * @param undertakeStrategyId
     * @return
     */
    SendPrizeResult sendPrizeByStrategyIdWithUndertakeFailedToThanks(String userId, String strategyId, String undertakeStrategyId);

    /**
     * 根据场景id查询对应的发奖规则
     *
     * @param sceneId
     * @return
     */
    List<String> queryRuIdsBySceneId(String sceneId);

    /**
     * 给当前用户，使用指定场景发奖（可能抛异常，有事务控制时，慎用）
     * @param sceneId
     * @return
     * @Deprecated：请明确指定用户
     * @see #sendPrizeBySceneId(String, String)
     */
    @Deprecated
    SendPrizeResult sendPrizeBySceneId(String sceneId);

    /**
     * 给指定用户，使用指定场景发奖（可能抛异常，有事务控制时，慎用）
     * @param userId
     * @param sceneId
     * @return
     */
    SendPrizeResult sendPrizeBySceneId(String userId, String sceneId);

    /**
     * 给当前用户发放一个道具
     *
     * @param spId     道具ID
     * @param quantity 初始化属性值
     * @return 记录ID
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#giveStageProperty(String, String, int)
     * @see StagePropertyApi#giveStageProperty(String, String, int, String)
     */
    @Deprecated
    Long giveStageProperty(String spId, int quantity);
    @Deprecated
    Long giveStageProperty(String spId, int quantity, String extra);

    /**
     * 消耗当前用户的道具
     *
     * @param spId     道具ID
     * @param quantity 属性减少数量
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#consumeStageProperty(String, String, int)
     * @see StagePropertyApi#consumeStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean consumeStageProperty(String spId, int quantity);
    @Deprecated
    Boolean consumeStageProperty(String spId, int quantity, String extra);

    /**
     * 当前用户的道具属性增加
     *
     * @param spId     道具ID
     * @param quantity 属性增加数量
     * @param max      属性增加最大值  为NUll不限制最大
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#giveStageProperty(String, String, int)
     * @see StagePropertyApi#giveStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean stagePropertyIncr(String spId, int quantity, Long max);
    @Deprecated
    Boolean stagePropertyIncr(String spId, int quantity, String extra, Long max);

    /**
     * 当前用户道具数据减少
     *
     * @param spId     道具ID
     * @param quantity 减少数量
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#consumeStageProperty(String, String, int)
     * @see StagePropertyApi#consumeStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean stagePropertyDecr(String spId, int quantity);
    @Deprecated
    Boolean stagePropertyDecr(String spId, int quantity, String extra);

    /**
     * 修改覆盖道具属性
     *
     * @param spId
     * @param quantity
     * @return
     * @see #getStagePropertyApi()
     */
    @Deprecated
    Boolean updateStagePorperty(String spId, int quantity);
    @Deprecated
    Boolean updateStagePorperty(String spId, int quantity, String extra);

    /**
     * 查询用户某个道具属性
     *
     * @param spId 道具ID
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#getSomebodyStageProperty(String, String)
     */
    @Deprecated
    Long queryStageProperty(String spId);

    /**
     * 批量查询用户道具属性
     *
     * @param spIds 道具ID集合
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#getSomebodySomeStageProperty(String, List)
     */
    @Deprecated
    Map<String, Long> queryStageProperty(List<String> spIds);

    /**
     * 直接发奖，不通过发奖规则进行发奖
     *
     * @param customStrategyId 自定义策略id(不要使用界面配置的策略ID)，自行编造即可，不要重复
     * @param prizeId
     * @return
     * @see #getPrizeApi()
     * @see PrizeApi#sendPrize(String, String, String)
     * 不使用策略直接发奖运营配置无法配置库存
     */
    @Deprecated
    StrategyResult sendPrizeWithDirect(String customStrategyId, String prizeId);

    /**
     * 兑吧APP签名
     *
     * @param params 需要签名的参数
     * @return params 签名好的参数，里面会加入sign, appKey，timestamp
     * @see #getDuibaApi()
     * @see DuibaApi#getSignApi()
     * @see cn.com.duiba.projectx.sdk.utils.SignApi#doSign(Long, Map)
     * @deprecated 改用UserRequestApi.getDuibaApi().getSignApi().doSign()
     */
    @Deprecated
    Map<String, String> duibaSign(Map<String, String> params);

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     *
     * @return
     * @see UserRequestContext#getPartnerUserId()
     */
    @Deprecated
    String getDuibaPartnerUserId();

    /**
     * 如需防止用户并发行为，请优先使用@getUserLock()
     * <p>
     * Redis:获取一个锁
     * 注：获得的锁对象（如果为null表示获取锁失败），后续可以调用该对象的unlock方法来释放锁
     *
     * @param key           KEY
     * @param expireSeconds 失效时间
     * @return 锁对象
     * @see #newLock(String, int)
     */
    @Deprecated
    public RedisLock redisGetLock(final String key, long expireSeconds);

    /**
     * 如需防止用户并发行为，请优先使用@getUserLock()
     * <p>
     * Redis:获取一个锁
     * 注：获得的锁对象（如果为null表示获取锁失败），后续可以调用该对象的unlock方法来释放锁
     *
     * @param key                     KEY
     * @param expireSeconds           失效时间
     * @param maxRetryTimes           最大重试次数,如果获取锁失败，会自动尝试重新获取锁；
     * @param retryIntervalTimeMillis 每次重试之前sleep等待的毫秒数
     * @return
     */
    @Deprecated
    public RedisLock redisGetLock(final String key, long expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * Redis:计数器
     *
     * @param key      KEY
     * @param delta    计数
     * @param timeout  失效时间
     * @param timeUnit 时间单位
     * @return 当前结果
     */
    @Deprecated
    public Long redisIncrBy(String key, long delta, long timeout, TimeUnit timeUnit);

    /**
     * Redis: GetAtomicValue
     *
     * @param key
     * @return
     */
    @Deprecated
    public Long redisGetAtomicValue(String key);

    /**
     * 获取用户锁接口
     * <p>
     * 请使用 context.getUserLock()
     *
     * @return
     */
    @Deprecated
    public UserLock getUserLock();

    /**
     * 获取LoggerService
     * 日志类的方法接口
     *
     * @return LoggerService
     */
    LoggerService getLoggerService();

    /**
     * 获取排行榜的服务接口
     *
     * @return
     * @see #getCommonRankingApi()
     */
    @Deprecated
    RankingApi getRankingApi();

    /**
     * @return
     * @see #getUserDataNewApi()
     */
    @Deprecated
    UserDataApi getUserDataApi();

    UserContext getMyUserContext();

    UserContext getUserContext(String userId);

    @Deprecated
    ProjectApi getProjectApi();

    /**
     * 检查是否给的字符串包含敏感词信息
     *
     * @param checkStr 需要检查的文本
     */
    SensitiveWordData checkContainSenWord(String checkStr);

    HttpAsyncClient getHttpAsyncClient();

    ComponentApi getComponentApi();
}
