package cn.com.duiba.projectx.sdk.pay.wxfavorsuercoupon;


import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 微信立减金发放
 * @author lizhi
 * @date 2023/5/17 4:54 PM
 */
public class WxFavorUserCouponsRequest implements Serializable {
    private static final long serialVersionUID = 841008421510428339L;

    /**
     * 商户ID
     */
    @NotBlank(message = "mchId must not be null")
    @Size(max = 32, message = "mchId不能超过32")
    private String mchId;

    /**
     * 批次号		 
     */
    @NotBlank(message = "stockId must not be null")
    @Size(max = 20, message = "stockId不能超过20")
    private String stockId;

    /**
     * 商户单据号		 
     */
    @NotBlank(message = "outRequestNo must not be null")
    @Size(max = 128, message = "outRequestNo不能超过128")
    private String outRequestNo;

    /**
     * 公众账号ID		 
     */
    @NotBlank(message = "appId must not be null")
    @Size(max = 128, message = "appId不能超过128")
    private String appId;

    /**
     * 创建批次的商户号	 
     */
    @NotBlank(message = "stockCreatorMchId must not be null")
    @Size(max = 20, message = "stockCreatorMchId不能超过20")
    private String stockCreatorMchId;

    /**
     * 收款用户openid
     */
    @NotBlank(message = "openId must not be null")
    @Size(max = 64, message = "openId不能超过64")
    private String openId;

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getStockId() {
        return stockId;
    }

    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getStockCreatorMchId() {
        return stockCreatorMchId;
    }

    public void setStockCreatorMchId(String stockCreatorMchId) {
        this.stockCreatorMchId = stockCreatorMchId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
}
