package cn.com.duiba.projectx.sdk.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;

/**
 * 特别说明：
 * 1、iv（16位）固定，key也需要是16位的
 * 2、加密时，长度不够的部分会自动填充空字符，如果是后端加密，前端解密，需告知前端解密后需要trim处理
 */
public class AESUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtils.class);
    // 转换方式
    private static final String TRANSFORMATIONS = "AES/CBC/NOPadding";
    // 加密算法
    private static final String ALGORITHM = "AES";
    // 加密iv（16位）
    private static final String IV = "cDOiBC1n2QrkAY2P";

    private AESUtils() {
    }

    public static void main(String[] args) {
        LOGGER.info(encodeByAes("666", "eb88679b11e74bcd"));
    }

    /**
     * AES加密
     * @param content
     * @param key
     * @return
     */
    public static String encodeByAes(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATIONS);
            int blockSize = cipher.getBlockSize();
            byte[] dataBytes = content.getBytes();
            int plaintextLength = dataBytes.length;
            if (plaintextLength % blockSize != 0) {
                plaintextLength = plaintextLength + (blockSize - (plaintextLength % blockSize));
            }

            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);

            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IV.getBytes());

            cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivParameterSpec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(plaintext));
        } catch (Exception e) {
            LOGGER.info("AES加密异常，content=[{}]", content, e);
            return "";
        }
    }

    /**
     * AES解密
     * @param content
     * @param key
     * @return
     */
    public static String decodeByAes(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATIONS);
            cipher.init(
                    Cipher.DECRYPT_MODE,
                    new SecretKeySpec(key.getBytes(), ALGORITHM),
                    new IvParameterSpec(IV.getBytes())
            );
            return new String(cipher.doFinal(Base64.getDecoder().decode(content))).trim();
        } catch (Exception e) {
            LOGGER.info("AES解密异常，content=[{}]", content, e);
            return "";
        }
    }
}
