package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.data.RankingConfigData;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

public interface CommonRankingApi extends Api {
    /**
     * 获取项目id
     * @return 项目id
     */
    String getProjectId();

    /**
     * 更新指定用户排行榜分数
     * @param somebodyUserId 指定用户id
     * @param type 期次
     * @param score 分数
     * @param high2low 是否从高到低排（true：从高到低，false：从低到高）
     */
    void updateSomebodyRankingScore(String somebodyUserId, String type, int score, boolean high2low);

    /**
     * 指定用户排行榜分数+1
     * @param somebodyUserId 指定用户id
     * @param type 期次
     */
    void updateSomebodyRankingScoreByIncr(String somebodyUserId, String type);

    /**
     * 指定用户排行榜分数+n
     * @param somebodyUserId 指定用户id
     * @param type 期次
     * @param incr 增加的分数
     */
    void updateSomebodyRankingScoreByIncr(String somebodyUserId, String type, int incr);

    /**
     * 清零指定用户的分数
     * @param somebodyUserId 指定用户id
     * @param type 期次
     */
    void clearSomebodyRankingScore(String somebodyUserId, String type);

    /**
     * 将指定用户加入排行榜的黑名单
     * @param somebodyUserId  指定用户id
     * @param type 期次
     * @return 返回是否将此人加入排行榜黑名单成功
     * 排行榜已经过期结束也会返回false，
     * 用户还未参与榜单也会返回false，
     * 重复标记用户也会返回false
     */
    Boolean invalidSomebodyScore(String type, String somebodyUserId);

    /**
     * 查询指定用户的排行榜信息
     * @param type 期次
     * @param somebodyUserId 指定用户id
     * @return 排行榜信息（为null表示 未参与）
     */
    Ranking getSomebodyRankInfo(String type, String somebodyUserId);

    /**
     * 查询指定用户的排名
     * @param type 期次
     * @param somebodyUserId 指定用户id
     * @return 排名（为null表示 未参与 或 3000名开外）
     */
    Integer getSomebodyRank(String type, String somebodyUserId);

    /**
     * 获取指定用户的《得分，排名》
     * 未参与：得分和排名均为null
     * 参与了：排名在3000以内（包含），则得分和排名均正常返回
     * 参与了：排名在3000名开外，则返回3001（可让前端通过判断大于x，则显示x+，x不可大于3000，例如x为999）
     * @param type
     * @param somebodyUserId
     * @return
     */
    Pair<Integer, Integer> getSomebodyMaxScoreAndIndex(String type, String somebodyUserId);

    /**
     * 获取排行榜前n名的信息
     * @param type 期次
     * @param topN 前几名（不允许超过1000，会有性能问题）
     * @return 信息列表
     */
    List<Ranking> getTopN(String type, int topN);

    /**
     * 导入排行榜配置数据
     * @param type 期次
     * @param rankingName 排行榜名称
     * @param manualSendPrize 是否手动发奖（true-手动开奖）
     */
    void insertRankingConfig(String type, String rankingName, Boolean manualSendPrize);

    /**
     * 根据期次获取排行榜配置
     * @param type 期次
     * @return 排行榜配置信息（为null表示没有）
     */
    RankingConfigData getRankingConfigByType(String type);
}
