package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public interface ConfigurationApi extends Api {
    /**
     * 获取配置项（字符串）
     * @param key
     * @return
     */
    String getStringVariable(String key);

    /**
     * 获取配置项（整型）
     * @param key
     * @return
     */
    int getIntVariable(String key);

    /**
     * 获取配置项（数值）
     * @param key
     * @return
     */
    double getDoubleVariable(String key);

    /**
     * 获取配置项（日期时间）
     * @param key
     * @return
     */
    Date getDateVariable(String key);

    /**
     * 获取配置项（日期时间）
     * @param key
     * @return
     */
    LocalDateTime getLocalDateTimeVariable(String key);

    /**
     * 获取配置项（JSON_ARRAY）
     * 当配置项真实值解析为表单后仅存在"1"行数据时，建议使用{@link ConfigurationApi#getJsonVariable(String, Class)}，该方法直接返回解析列表中的唯一数据对象！
     * @param key
     * @param tClass
     * @param <T>
     * @return
     */
    <T> List<T> getJsonArrayVariable(String key, Class<T> tClass);

    /**
     * 获取配置项（JSON）
     * 当配置项真实值解析为表单后存在多行数据时，调用此方法会抛出业务异常！若设计如此则应使用{@link ConfigurationApi#getJsonArrayVariable(String, Class)}；
     * @param key
     * @param tClass
     * @param <T>
     * @return
     */
    <T> T getJsonVariable(String key, Class<T> tClass);

    /**
     * 获取配置项（图片）
     * @param key
     * @return
     */
    String getImageVariable(String key);
}
