package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.pay.abc.AbcPayApi;
import cn.com.duiba.projectx.sdk.pay.boc.BocPayApi;
import cn.com.duiba.projectx.sdk.pay.ccb.CcbPayApi;
import cn.com.duiba.projectx.sdk.pay.cebxyk.CebXykPayApi;
import cn.com.duiba.projectx.sdk.pay.citic.CiticPayApi;
import cn.com.duiba.projectx.sdk.pay.cmb.CmbLifePayApi;
import cn.com.duiba.projectx.sdk.pay.gdhx.api.GdhxPayApi;
import cn.com.duiba.projectx.sdk.pay.icbc.IcbcPayApi;
import cn.com.duiba.projectx.sdk.pay.icbcelife.IcbcElifePayApi;
import cn.com.duiba.projectx.sdk.pay.union.UnionPayApi;
import cn.com.duiba.projectx.sdk.pay.union.ums.UnionPayUmsApi;
import cn.com.duiba.projectx.sdk.pay.xib.XibPayApi;

/**
 * @author liugq
 * @date 2020/03/22
 */
public interface PayApi {

    /**
     * 微信支付
     */
    WxPayApi getWxPayApi();

    /**
     * 支付宝支付
     * @return
     */
    AliPayApi getAliPayApi();

    /**
     * 中国银行支付
     * @return BocPayApi
     */
    BocPayApi getBocPayApi();

    /**
     * 农行支付
     * @return
     */
    AbcPayApi getAbcPayApi();

    /**
     * 建行支付
     * @return
     */
    CcbPayApi getCcbPayApi();

    /**
     * 中信银行支付
     * @return
     */
    CiticPayApi getCiticPayApi();

    /**
     * 工行e支付H5
     * @return
     */
    IcbcPayApi getIcbcPayApi();

    /**
     * 工行e生活支付（app端 && 微信小程序端）
     * @return
     */
    IcbcElifePayApi getIcbcElifePayApi();

    /**
     * 浙江银联支付
     * @return
     */
    UnionPayApi getUnionPayApi();

    /**
     * 中国光大银行信用卡中心支付
     *
     * @return
     */
    CebXykPayApi getCebXykPayApi();

    /**
     * 广东华兴银行支付
     * @return
     */
    GdhxPayApi getGdhxPayApi();

    /**
     * 深圳银联天满平台云闪付支付
     *
     * @return {@link UnionPayUmsApi}
     */
    UnionPayUmsApi getUnionPayUmsApi();

    /**
     * 厦门国际支付
     * @return
     */
    XibPayApi getXibPayApi();

    /**
     * 招商银行-掌上生活-H5支付
     * @return api
     */
    CmbLifePayApi getCmbLifePayApi();
}
