package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.data.ProjectWhiteListData;

import java.util.List;

public interface WhiteListApi extends Api {
    /**
     * 根据partnerUserId，判断某个用户是否是白名单用户（此方法未指定groupId，建议使用指定了groupId的方法）
     * @param partnerUserId
     * @return
     */
    boolean isWhiteListUser(String partnerUserId);

    /**
     * 根据groupId和partnerUserId，判断某个用户是否是白名单用户
     * @param groupId
     * @param partnerUserId
     * @return
     */
    boolean isWhiteListUser(String groupId, String partnerUserId);

    /**
     * 根据partnerUserId，获取白名单用户信息（根据groupId去重）
     * @param partnerUserId
     * @return
     */
    List<ProjectWhiteListData> listWhiteByPartnerUserId(String partnerUserId);

    /**
     * 根据groupId，获取白名单用户partnerUserId列表（慎用）
     * @param groupId
     * @return
     */
    List<String> getWhitePartnerUserIdListByGroupId(String groupId);

    /**
     * 根据groupId，分页获取白名单用户信息（按照id升序）
     * @param groupId
     * @param pageNo 第几页（从1开始）
     * @param pageSize 每页多少条
     * @param startId 开始id，包括此id，可以为空
     * @return
     */
    PageList<ProjectWhiteListData> pageListWhiteByGroupId(String groupId, int pageNo, int pageSize, Long startId);

    /**
     * 新增白名单,主键或（projectId，groupId，partnerUserId）唯一索引冲突则更新
     * @param groupId 不传，默认为0
     * @param partnerUserId
     * @param partnerExtra 扩展字段
     * @return
     */
    int insertOrUpdate(String groupId, String partnerUserId, String partnerExtra);

    /**
     * 批量新增白名单，一次最多2000条 主键或（projectId，groupId，partnerUserId）唯一索引冲突则更新
     * @param groupId 不传，默认为0
     * @param dataList 只需传partnerUserId和partnerExtra
     * @return
     */
    int insertOrUpdateList(String groupId, List<ProjectWhiteListData> dataList);

    /**
     * 根据groupId和partnerUserId列表删除白名单信息
     * @param groupId
     * @param partnerUserIdList
     * @return
     */
    int deleteByGroupIdAndPartnerUserIdList(String groupId, List<String> partnerUserIdList);
}
