package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.riskmddata.EventName;

import java.util.Map;

/**
 * @author jiaxz
 * 埋点接口,活动维度/projectx/pxxxxxx,暂不支持web线程以外的线程、servlet异步响应的线程
 * @see https://alidocs.dingtalk.com/i/nodes/mM3zoYAw1Rr8Dqx0OkxRWnZ07y9NpXxD?nav=share&navQuery=spaceId%3D3YxXA12pn0K4jXNy
 *
 */
public interface LoggerService {
    /**
     * 自定义埋点,慎用在自定义事件的ex中打印埋点。一个请求只能打印一个埋点
     * @param eventName
     * @param key key 额外添加放在ext字段内的key
     * @param value value 额外添加放在ext字段内的value
     */
    void putAccessLogExPair(EventName eventName, String key, String value);

    /**
     * 通用埋点，根据事件名和场景打印埋点。一个请求只能打印一个埋点
     * @param eventName 事件
     */
    void putAccessLog(EventName eventName);

    /**
     * 通用埋点，根据事件名和场景打印埋点。一个请求只能打印一个埋点
     * @param eventName 事件
     * @param param 放在ext字段内的参数
     */
    void putAccessLog(EventName eventName, Map<String,Object> param);

}
