package cn.com.duiba.projectx.sdk.annotation.risk;

import cn.com.duiba.projectx.sdk.riskmddata.MarkTypeEnum;
import cn.com.duiba.projectx.sdk.riskmddata.SendPrizeDecisionEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标识是否走风控
 * MarkTypeEnum枚举类型
 *   DEFAULT("0","默认(不走风控)"),
 *   ACCESS("1", "访问"),   暂不支持
 *   ACTIVITY("2", "活动参与"),
 *   REWARD("3", "奖励"),   暂不支持
 *   EXCHANGE("4", "兑换"),  暂不支持
 *   EXTRACTCASH("5", "提现"),  暂不支持
 *
 * SendPrizeDecisionEnum 枚举类型
 *    SENDPRIZEGORISK("6", "发奖走风控"),
 *    SENDPRIZENOGORISK("0", "发奖不走风控"),
 *
 * /@EnableRiskControl(vaule = MarkTypeEnum.ACCESS,isSPtoRisk = SendPrizeDecisionEnum.SENDPRIZEGORISK)
 * @author zhangruofan
 *
 * 目前星速台只支持参与和发奖场景，其他的暂不支持
 */
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Target({ElementType.METHOD,ElementType.ANNOTATION_TYPE})
public @interface EnableRiskControl {
    /**
     * 风控场景
     */
    MarkTypeEnum value() default MarkTypeEnum.ACTIVITY;

    /**
     * 发奖是否走风控
     * 发奖没有风控
     */
    @Deprecated
    SendPrizeDecisionEnum isSPtoRisk() default SendPrizeDecisionEnum.SENDPRIZENOGORISK;
}
