package cn.com.duiba.projectx.sdk.component.inviteassist;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.AssistRecordResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.AssistResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteAssistConfigResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteAssistQueryParam;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteRecordResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteResult;
import cn.com.duiba.projectx.sdk.utils.PageList;

import java.util.List;

public interface InviteAssistApi extends UserRequestApi {

    /**
     * 查询组件配置信息
     */
    InviteAssistConfigResult getComponentConfig(String playwayId);

    /**
     * 获取邀请码
     * <p> 邀请码生产规则:
     *      1. 6位,数字或字母.
     *      2. ⚠️ 同用户同玩法下,是同一个邀请码.
     * </p>
     *
     * @param playwayId 玩法ID
     * @return
     */
    InviteResult getInviteCode(String playwayId);


    /**
     * 获取邀请码且重置周期
     *
     * @param playwayId
     * @return
     */
    InviteResult getInviteCodeCoverPeriod(String playwayId);

    /**
     * 根据邀请码获取用户Id
     *
     * @param inviteCode 邀请码
     * @return
     */
    String getUserIdByInviteCode(String inviteCode);

    /**
     * 助力
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * <p>1. 助力条件判断
     * <p>2. 接受邀请
     * <p>3. 给分享者发奖
     *
     * @param playwayId 玩法ID
     * @param inviteCode 邀请码
     * @param extra 扩展值
     * @return
     */
    AssistResult doAssist(String playwayId, String inviteCode, String extra);

    /**
     * 助力
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * <p>1. 助力条件判断
     * <p>2. 接受邀请
     * <p>3. 给分享者发奖
     *
     * @param playwayId 玩法ID
     * @param inviteCode 邀请码
     * @param ruleId 发奖规则
     *               运营配置必须选择[自定义]发奖规则
     * @param extra 扩展值
     * @return
     */
    AssistResult doAssist(String playwayId, String inviteCode, String ruleId, String extra);

    /**
     * 查询新邀请数量
     * <p>
     *     调用一下方法会清空新助力用户
     *      queryNewInviteCount,
     *      queryNewInviteRecords,
     *      queryTodayInviteRecords,
     *      queryInviteRecords
     * </p>
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    int queryNewInviteCount(String playwayId, String userId);

    /**
     * 查询所有邀请数量
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param distinctAssistUserId 是否去重助力者, 默认:false
     *                             true=去重
     *                             false=不去重
     * @return
     */
    int queryAllInviteCount(String playwayId, String userId, Boolean distinctAssistUserId);

    /**
     * 查询今日的邀请记录
     * <p>时间倒序
     * <p>返回最近500条记录
     * <p>清空新助力用户
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<InviteRecordResult> queryTodayInviteRecords(String playwayId, String userId);

    /**
     * 查询新邀请记录
     * <p>时间倒序
     * <p>返回最近200条记录
     * <p>清空新助力用户
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<InviteRecordResult> queryNewInviteRecords(String playwayId, String userId);

    /**
     * 查询邀请记录
     * <p>时间倒序
     * <p>清空新助力用户
     *
     * @param param 查询参数
     *  ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<InviteRecordResult> queryInviteRecords(InviteAssistQueryParam param);

    /**
     * 查询今日的助力记录
     * <p>时间倒序
     * <p>返回最近500条记录
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<AssistRecordResult> queryTodayAssistRecords(String playwayId, String userId);

    /**
     * 查询助力记录
     * <p>时间倒序
     *
     * @param param 查询参数
     *  ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<AssistRecordResult> queryAssistRecords(InviteAssistQueryParam param);

    /**
     * 查询所有助力数量
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param distinctShareUserId 是否去重分享者, 默认:false
     *                             true=去重
     *                             false=不去重
     * @return
     */
    int queryAllAssistCount(String playwayId, String userId, Boolean distinctShareUserId);

}
