package cn.com.duiba.projectx.sdk.component.share;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.OptionResult;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.share.dto.ShareQueryResult;
import cn.com.duiba.projectx.sdk.component.share.dto.ShareResult;

import java.util.List;

public interface ShareApi extends UserRequestApi {

    /**
     * 查询配置的奖品列表
     *
     * @param playwayId 玩法ID
     * @return
     */
    List<OptionResult> queryOptions(String playwayId);

    /**
     * 分享
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * <p>1.在有效期内
     * <p>2.获取邀请码
     * <p>3.获取分享次数, 加1保存.
     *
     * @param playwayId 玩法ID
     * @return
     */
    ShareResult share(String playwayId);

    /**
     * 分享
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * <p>1.在有效期内
     * <p>2.获取邀请码
     * <p>3.获取分享次数, 加1保存.
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    ShareResult share(String playwayId, String userId);

    /**
     * 分享并发奖
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * <p>1.在有效期内
     * <p>2.获取邀请码
     * <p>3.获取分享次数, 加1保存.
     * <p>4.发奖
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    ShareResult shareAndSendPrize(String playwayId, String userId);

    /**
     * 查询当前周期内的次数
     *
     * @param playwayId 玩法ID
     * @return
     */
    ShareQueryResult queryCount(String playwayId);

    /**
     * 查询当前周期内的次数
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    ShareQueryResult queryCount(String playwayId, String userId);

    /**
     * 领取最后一次分享的奖励
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * <p>1.在有效期内
     * <p>2.获取分享次数
     * <p>3.满足条件后, 发奖.
     *
     * @param playwayId 玩法ID
     * @param prizePendingCode 领奖code
     * @return
     */
    PrizeResult sendPrize(String playwayId, String prizePendingCode);

    /**
     * 领取最后一次分享的奖励
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * <p>1.在有效期内
     * <p>2.获取分享次数
     * <p>3.满足条件后, 发奖.
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param prizePendingCode 领奖code
     * @return
     */
    PrizeResult sendPrize(String playwayId, String userId, String prizePendingCode);

}
