package cn.com.duiba.projectx.sdk.data;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author zhangruofan
 * @date 2019/10/22
 */
public class NewConsumerDto {
    public static final String NOTLOGINUSERID = "not_login";	//未登录用户id
    public static final String NOTLOGINUSERID_GEN_NEW = "gen_new_";  //未登录用户 创建用户时  partnerUserId  开头是一次为前缀
    private static final String OPENBS_NOT_LOGIN_GEN = "gen_";  // 通过openBs链接产生的用户partnerUserId以"gen_"开头，此类用户按照未登录用户处理


    private Long cid;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 积分余额
     */
    private Long credits;

    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * VIP等级
     */
    private String vipGroup;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 是否新用户
     */
    private Boolean newUser;

    /**
     * 是否关注公众号
     */
    private Boolean followWx;

    private Date gmtCreate;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getVipGroup() {
        return vipGroup;
    }

    public void setVipGroup(String vipGroup) {
        this.vipGroup = vipGroup;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Boolean getNewUser() {
        return newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }

    public Boolean getFollowWx() {
        return followWx;
    }

    public void setFollowWx(Boolean followWx) {
        this.followWx = followWx;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    //统一判断是否是 未登录
    public boolean isNotLoginUser() {
        return this.partnerUserId != null && (this.partnerUserId.equals(NOTLOGINUSERID) || this.partnerUserId.startsWith(NOTLOGINUSERID_GEN_NEW));
    }

    public static boolean isNotLoginUser(String partnerUserId) {
        return StringUtils.isNotBlank(partnerUserId) && (partnerUserId.equals(NOTLOGINUSERID) || partnerUserId.startsWith(NOTLOGINUSERID_GEN_NEW));
    }


    /**
     * 判断用户是否未登录
     */
    public static boolean isNotLoginUserWithGen(String partnerUserId) {
        return StringUtils.isBlank(partnerUserId) || NOTLOGINUSERID.equals(partnerUserId)
                || partnerUserId.startsWith(OPENBS_NOT_LOGIN_GEN);
    }
}
