package cn.com.duiba.projectx.sdk.riskmddata;

/**
 * 埋点元事件名
 * https://alidocs.dingtalk.com/i/team/3YxXA12pn0K4jXNy/docs/3YxXAKgQkj2NDGNy# 「【积分商城2.0】数据采集规范v1.0.1」
 */
public enum EventName {
    ACTIVITY_VISIT("activity_visit", EventCondition.ACTIVITY_VISIT,"访问活动"),
    ACTIVITY_JOIN("activity_join", EventCondition.ACTIVITY_JOIN,"参与活动"),
    ACTIVITY_WIN("activity_win", EventCondition.ACTIVITY_WIN,"活动中奖"),
    ACTIVITY_GETPRIZE("activity_getprize", EventCondition.ACTIVITY_ORDER,"活动领奖"),
    ACTIVITY_SHARE("activity_share", EventCondition.ACTIVITY_JOIN,"分享活动"),
    GAME_FINISH("game_finish", EventCondition.ACTIVITY_JOIN,"完成游戏"),
    ACTIVITY_INVITE("activity_invite",EventCondition.ACTIVITY_JOIN,"后的那个邀请" ),
    ACTIVITY_ASSISTANT("activity_assistant",EventCondition.ACTIVITY_JOIN,"活动邀请" ),

    DEFAULT("-1", EventCondition.ACTIVITY_JOIN,"完成游戏"),

    ;

    private String key;
    private EventCondition condition;
    private String desc;

    EventName(String key, EventCondition condition,String desc) {
        this.key = key;
        this.condition = condition;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public EventCondition getCondition() {
        return condition;
    }

}
