package cn.com.duiba.projectx.sdk.utils;

import com.alibaba.fastjson.JSONObject;

import java.util.regex.Pattern;

/**
 * @author liujiahui
 * @since 2022/3/30
 */
public class ActivityUtils {


    /**
     * 简单手机号校验
     */
    public static final String PHONE_REG = "^1\\d{10}$" ;

    /**
     * 是否手机号码
     *
     * @param phoneNum
     * @return
     */
    public static boolean isPhoneNum(String phoneNum) {
        return Pattern.matches(PHONE_REG, phoneNum);
    }

    /**
     * 手机号隐藏
     *
     * @param phone
     * @return
     */
    public static String dealPhoneNum(String phone) {
        if (isPhoneNum(phone)) {
            return phone.substring(0, 3) + "****" + phone.substring(8);
        }
        return phone;
    }


    /**
     * 返回谢谢参与
     *
     * @return
     */
    public static JSONObject getThanksStrategy() {
        JSONObject obj = new JSONObject();
        obj.put("prizeId", "thanks");
        obj.put("optionId", "thanks");
        obj.put("prizeType", 0);
        obj.put("name", "谢谢参与");
        return obj;
    }


}
