package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.data.NewConsumerDto;

import java.util.List;

public interface ConsumerApi extends Api {
    /**
     * 批量获取用户信息
     * @param ids consumer ids
     * @return list
     * @throws BizRuntimeException exception
     */
    List<NewConsumerDto> listConsumerByConsumerIds(List<Long> ids) throws BizRuntimeException;

    /**
     * 当前用户是否为新用户
     * true 新用户  false 老用户
     * @param consumerId consumerId
     * @return boolean
     * @throws BizRuntimeException exception
     */
    boolean isNewUser(Long consumerId) throws BizRuntimeException;

    /**
     * 通过开发者用户id获取用户信息
     * @param appId appId
     * @param partnerUserId 开发者用户id
     * @return consumer
     * @throws BizRuntimeException exception
     */
    NewConsumerDto findByAppAndPartnerUserId(Long appId, String partnerUserId);

    /**
     * 通过开发者用户id获取用户信息
     * 走es
     * @param appId appId
     * @param partnerUserIds 开发者用户id集合
     * @return consumer
     * @throws BizRuntimeException exception
     */
    List<NewConsumerDto> findByAppAndPartnerUserIds(Long appId, List<String> partnerUserIds);

    /**
     * @description  通过key 查询consumerExtra表json里的扩展字段
     * @author liheping
     * @date 2020/12/3
     */
    String findConsumerExtra(Long consumerId, String key);
}
