package cn.com.duiba.quanyi.center.api.remoteservice.insurance.login;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceAccountDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceLoginAccountDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceLoginAccountSearchParam;

import java.util.List;

/**
 * 保司端-登录账户表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceLoginAccountService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectPage(InsuranceLoginAccountSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceLoginAccountSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司端-登录账户
     */
    InsuranceLoginAccountDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司端-登录账户
     * @return 执行结果
     */
    Long insert(InsuranceAccountDto dto);

    /**
     * 更新
     * @param dto 保司端-登录账户
     * @return 影响行数
     */
    int update(InsuranceLoginAccountDto dto);



    /**
     * 根据条件查询,查询所有登录集合
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectListNoPage(InsuranceLoginAccountSearchParam param);

    /**
     * 根据主键列表查询
     * @param ids 主键
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectByIds(List<Long> ids);

    /**
     * 根据手机号批量查询
     * @param accountPhones 手机号
     * @return
     */
    List<InsuranceLoginAccountDto> selectByAccountPhones(List<String> accountPhones);

    /**
     * 批量插入
     * 注意公司id和账号角色得一致  本方法仅支持批量插入同一公司下同一角色的用户
     * @param accountDtos 账号集合
     * @return 执行结果 插入成功的数据
     */
    List<InsuranceAccountDto> batchInsert(List<InsuranceAccountDto> accountDtos);

    /**
     * 同时更新坐席与角色
     * @param dto
     * @return
     */
    int updateAccountAndType(InsuranceAccountDto dto);


    /**
     * 手机号与用户名称模糊
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectPageVague(InsuranceLoginAccountSearchParam param);

    /**
     * 手机号与用户名称模糊
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCountVague(InsuranceLoginAccountSearchParam param);

}