/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum WxStockTypeEnum {
    DISCOUNT_CUT(1, "\u6536\u94f6\u53f0\u7acb\u51cf", false),
    COUPON_BANK(2, "\u94f6\u884c\u7acb\u51cf\u91d1", true),
    FIRST_BIND(3, "\u9996\u7ed1\u6709\u793c", false),
    MONTHLY_CARD_SWIPING(4, "\u6708\u6708\u5237", false),
    COUPON_MCH(5, "\u5546\u5bb6\u4ee3\u91d1\u5238", true);

    private final Integer type;
    private final String typeName;
    private final boolean supportApi;
    private static final Map<Integer, WxStockTypeEnum> ENUM_MAP;

    public static WxStockTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static String getNameByType(Integer type) {
        WxStockTypeEnum typeEnum = WxStockTypeEnum.getByType(type);
        if (typeEnum == null) {
            return "\u672a\u77e5";
        }
        return typeEnum.getTypeName();
    }

    public static boolean isSupportApi(Integer type) {
        WxStockTypeEnum typeEnum = WxStockTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum.isSupportApi();
    }

    public static List<Integer> getSupportApiList() {
        return Arrays.stream(WxStockTypeEnum.values()).filter(WxStockTypeEnum::isSupportApi).map(WxStockTypeEnum::getType).collect(Collectors.toList());
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSupportApi() {
        return this.supportApi;
    }

    private WxStockTypeEnum(Integer type, String typeName, boolean supportApi) {
        this.type = type;
        this.typeName = typeName;
        this.supportApi = supportApi;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(WxStockTypeEnum.values()).collect(Collectors.toMap(WxStockTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

