/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdMakeUtil {
    private static final Logger log = LoggerFactory.getLogger(IdMakeUtil.class);
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final String PREFIX = "Qy1";

    private IdMakeUtil() {
    }

    public static String encodingId(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        id = id << 3 ^ 7L;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return PREFIX + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank((String)encode)) {
            return null;
        }
        try {
            StringBuilder substring = new StringBuilder(encode.substring(4));
            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        }
        catch (Exception e) {
            log.info("decode ID error; id = {}", (Object)encode, (Object)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String s = IdMakeUtil.encodingId(607L);
        System.out.println(DateUtils.getMinuteDate((String)"2020-03-31 22:00").getTime());
        System.out.println(s);
        System.out.println(IdMakeUtil.decodingId("Kj22NTgzMQ"));
    }
}

