package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 上传任务状态
 * @author lizhi
 * @date 2023/3/29 2:09 PM
 */
@Getter
@AllArgsConstructor
public enum UploadTaskStatusEnum {
    // 0-初始化 1-上传中 2-上传失败(系统报错) 3-上传完成
    NIT(0, "初始化"),
    IMPORTING(1, "导入中"),
    IMPORT_FAILURE(2, "导入失败"),
    IMPORT_SUCCESS(3, "导入成功"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;
}
