package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2023/8/21 14:35
 */
@Data
public class WxCouponAllocationParam implements Serializable {
    
    private static final long serialVersionUID = 4054185207688365963L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private Integer stockType;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 微信返回的已发券数量
     */
    private Long distributedCoupons;

    /**
     * 用户领券后有效期为多少天，用于告警
     */
    private Integer userValidityPeriod;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;
    
}
