package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveRecordDto;
import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeReceiveRecordListParam;

import java.util.List;

/**
 * 活动奖品领取记录
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveRecordService {

    /**
     * 根据活动和用户查询
     *
     * @param activityType
     * @param activityId   活动
     * @param userId       用户
     * @return 领取记录列表
     * @see BizActTypeEnum
     */
    List<ActivityPrizeReceiveRecordDto> selectByActivityUserWithType(Integer activityType, Long activityId, Long userId);

    /**
     * 根据奖品、用户查询
     *
     * @param activityType
     * @param activityPrizeId 奖品ID
     * @param userId          用户ID
     * @return 领取记录
     * @see BizActTypeEnum
     */
    ActivityPrizeReceiveRecordDto selectByActivityPrizeUserWithType(Integer activityType, Long activityPrizeId, Long userId);

    /**
     * C端-用户领取记录分页查询
     *
     * @param param 参数
     * @return 领取记录
     */
    List<ActivityPrizeReceiveRecordDto> selectUserRecordListWithParam(ActivityPrizeReceiveRecordListParam param);
}